#ifndef DAQ_H
#define DAQ_H

//INCLUDES
#include "Channel.h"
#include "Multiplexer.h"
#include "Amplifier.h"
#include "ADC.h"
#include "Measurement.h"


class DAQ
{
private:
    Channel **channels;
    Multiplexer *multiplexer;
    Amplifier *amplifier;
    ADC *adc;
    bool initialized;

public:
    DAQ(void);
    ~DAQ(void);

    //GETTERS
    Measurement* measure(void);
    int getChannelGain(int channel);
    bool ChannelEnabled(int channel);
    bool ChannelsDisabled();
    bool Initialized(void);

    //SETTERS
    void setChannelGain(int channel,int gain);
    void enableChannel(int channel);
    void disableChannel(int channel);
    void setInitialized(bool init);

};
#endif