#ifndef ADC_H
#define ADC_H

#include "stdint.h"

class ADC
{
private:
    bool BIPOLAR;
    bool TEN;
    bool PD;
    bool IMPULSE;
    bool WARP;
    bool OB_2C;

    void setADC();
public:
    ADC(void);
    ~ADC(void);

    //GETTERS
    uint16_t measure(void);
    bool getBIPOLAR(void);
    bool getTEN(void);
    bool getPD(void);
    bool getIMPULSE(void);
    bool getWARP(void);
    bool getOB_2C(void);

    //SETTERS
    void setBIPOLAR(bool bipolar);
    void setTEN(bool ten);
    void setPD(bool pd);
    void setIMPULSE(bool impulse);
    void setWARP(bool warp);
    void setOB_2C(bool ob_2c);
};
#endif