#include "ADC.h"
#include "mbed.h"
#include "stdint.h"

Serial bb(USBTX, USBRX);

DigitalIn busy(p11);
DigitalIn sdout(p16);
DigitalOut cnvst(p10);
DigitalOut sdclk(p15);

DigitalOut scin(p14);
DigitalOut sccs(p12);
DigitalOut scclk(p13);

ADC::ADC(void)
{
    bb.baud(115200);
    
    this->BIPOLAR = true;
    this->TEN = true;
    this->PD = false;
    this->IMPULSE = true;
    this->WARP = true;
    this->OB_2C = true;

    sccs = 1;
    this->setADC();
}

ADC::~ADC(void)
{
}

//GETTERS
uint16_t ADC::measure(void)
{
    //Hier gaan we de data uitlezen...
    uint16_t data;

    //1. new data conversion
    cnvst = 0;
    wait_us(1);
    
    //2. nakijken of busy 0 is, of wachten tot hij 0 is.
    while(busy == 1);
    cnvst = 1;

    for (int i = 15; i >= 0; i--)
    {
        sdclk = 1;
        wait_us(1);

        data |= sdout <<i;
        sdclk = 0;
        wait_us(1);
    }
    return(data);
}
bool ADC::getBIPOLAR(void)
{
    return(this->BIPOLAR);
}
bool ADC::getTEN(void)
{
    return(this->TEN);
}
bool ADC::getPD(void)
{
    return(this->PD);
}
bool ADC::getIMPULSE(void)
{
    return(this->IMPULSE);
}
bool ADC::getWARP(void)
{
    return(this->WARP);
}
bool ADC::getOB_2C(void)
{
    return(this->OB_2C);
}


//SETTERS
void ADC::setBIPOLAR(bool bipolar)
{
    this->BIPOLAR = bipolar;
    this->setADC();
}
void ADC::setTEN(bool ten)
{
    this->TEN = ten;
    this->setADC();
}
void ADC::setPD(bool pd)
{
    this->PD = pd;
    this->setADC();
}
void ADC::setIMPULSE(bool impulse)
{
    this->IMPULSE = impulse;
    this->setADC();
}
void ADC::setWARP(bool warp)
{
    this->WARP = warp;
    this->setADC();
}
void ADC::setOB_2C(bool ob_2c)
{
    this->OB_2C = ob_2c;
    this->setADC();
}


//privates
void ADC::setADC(void)
{
    //onze data opmaken
    char data = 0;
    data |= this->BIPOLAR << 7;
    data |= this->TEN << 6;
    data |= this->PD << 5;
    data |= this->IMPULSE << 4;
    data |= this->WARP << 3;
    data |= this->OB_2C << 2;
    data |= 0 << 1;
    data |= 0 << 0;

    //Timing diagrama uitvoeren
    scclk = 0;
    //1. SCCS LAAG MAKEN
    sccs =  0;
    wait_us(1);

    //2. STARTBIT VERZENDEN
    scin=1;
    scclk = 1;
    wait_us(1);

    scclk = 0;
    wait_us(1);

    //3. onze data verwerken
    for (int i = 7; i >= 0; i--)
    {
        scin = (data >> i) & 1;
        scclk = 1;
        wait_us(1);

        scclk = 0; 
        wait_us(1);
    }

    //4. SCCS HOOG MAKEN 
    sccs = 1;
    scclk = 0;
    wait_us(1);
}