
//Warning: Incompatible redefinition of macro "MBED_RAM_SIZE"  in "tmp/HU5Hqj", Line: 39, Col: 10
#ifndef MBED_RAM_SIZE
#define MBED_RAM_SIZE 0x00018000
#endif

#include "QEI.h"
#include "SWPos.h"

#include "Timers.h"
//#include "Menu.h"
#include "Eeprom.h"
//#include "main.h"
//#include "app_config.h"

#define MAX_CHAR_PER_LINE   28
#define TEXT_ROW_SPACING    16
#define FONT_CHAR_WIDTH 8
#define FONT_CHAR_HEIGHT    16

//#include "mbed.h"
#include "DisplayDriver.h"
//#include "DmTftIli9341.h"
//#include "DmTouch.h"
//#include "DmTouchCalibration.h"

// LA:  Theory of Operation
//      ===================
//
//  Il PWM funziona da sè in Interrupt
//  Il QEI funziona da sè in Interrupt
//  Se si creano dei Ticker (Che sono a loro volta interrupt(s)) è possibile che PWM e QEI perdano correlazione con l'HW.
//
//  PQM
//
//  Il rinfresco del Display e la gestione del motion vanno fatte il più frequentemente possibile ma fuori dal loop dei Ticker.
//  Con qst versione (LA0005, che termina un FORK (il successivo è LA0010) quanto detto sopra è FUNZIONANTE.
//  Questo messaggio è incluso nel "commitment"

/*!
 * \brief Define IO for Unused Pin
 */
//DigitalOut  F_CS    (D6);               // MBED description of pin
//DigitalOut  SD_CS   (D8);               // MBED description of pin

DigitalIn   userButton  (USER_BUTTON);

AnalogIn    adc_temp    (ADC_TEMP);
AnalogIn    adc_vref    (ADC_VREF);
AnalogIn    adc_vbat    (ADC_VBAT);

//  PWM
//  ===
//
PwmOut PWM_PB3(PWM_OUT);       // LA:  PWM_OUT = D3 = PB_3

//  Motion
//  ======
//
//Ticker POS_MotionScan;                              //

QEI Stabilus322699  (PA_1, PA_0, NC, 100, QEI::X4_ENCODING);
//
in_sPosizionatoreSW    in_PosizionatoreSW;
out_sPosizionatoreSW   out_PosizionatoreSW;

//  LCD Display
//  ===========
//
//Ticker LCD_RefreshViews;                            //

//extern void    StabilusMenu   (uint32_t, uint32_t, int64_t);                 // LA:  Prototype ...

void    FactoryReset    (void) {
    EepromFactoryReset( );
    HAL_NVIC_SystemReset( );
}

/*
void    LCD____tScan (void) {
//    StabilusMenu (out_PosizionatoreSW.ui32_PreviousStep_ms, out_PosizionatoreSW.ui32_ActualStepSampled_ms, out_PosizionatoreSW.ui32_PassedActual_ms);
}


void    Motion_tScan (void) {
    PosizionatoreSW (in_PosizionatoreSW, out_PosizionatoreSW);
}
*/

//  =======
//  =======
//  Main(s)
//  =======
//  =======
//
int main    (void){
//int32_t i32_Pulses;
//    F_CS =  1;          // LA:  HW Initialization InProgress 
//    SD_CS = 1;          // LA:  HW Initialization InProgress 
//    BoardLED3 = 1;

    EepromInit();       // LA:  Inizializza la EEProm
    TimersInit();       // LA:  Parte il Timer a 1ms

    // LA:  FactoryReset se "userButton" premuto all'avvio
    //
    if  (userButton == 0) {
        FactoryReset();
    }

    DisplayDriverInit();
//    LCM_SetTextColor(BLUE, BLACK);
//    LCM_SetTextColor(GRAY1, BLACK);
//    LCM_SetTextColor(GRAY2, WHITE);
    LCM_SetTextColor(BLACK, WHITE);

//    MenuInit();                                             // LA:  Inizializza il Display
//    LCD_RefreshViews.attach_us  (&LCD____tScan, 250000);    //      Scansione LCD @100ms

    // LA:  Motion (1st) Setup
    //
    in_PosizionatoreSW.b_AxisPowered =  false;
    in_PosizionatoreSW.b_ACPos_Homed =  false;
    in_PosizionatoreSW.i32_Max_Speed =  1024;       // [ui]
    in_PosizionatoreSW.i32_ZeroSpeed =  0;          //

    in_PosizionatoreSW.b_JogMode =  false;
    in_PosizionatoreSW.b_JogFW =    false;
    in_PosizionatoreSW.b_JogBW =    false;
    in_PosizionatoreSW.i32_JogAccel_ms =    500;    // [ms]
    in_PosizionatoreSW.i32_JogDecel_ms =    250;    //
    //
    in_PosizionatoreSW.f_JogSpeed_x100_FW = 25.0;   // % of "i32_Max_Speed"
    in_PosizionatoreSW.f_JogSpeed_x100_BW = 25.0;   //

    in_PosizionatoreSW.b_ServoLock =    false;
    in_PosizionatoreSW.rtServoLock_Q =  false;
    //
    in_PosizionatoreSW.i64_TargetPosition = 0;      // [ui]
    in_PosizionatoreSW.i64_ActualPosition = 0;      //
    in_PosizionatoreSW.i64_AccelerationWindow = 0;  // LA:  Spazio concesso all'accelerazione.
    in_PosizionatoreSW.i64_DecelerationWindow = 0;  //      Spazio concesso alla decelerazione, è prioritario rispetto all'accelerazione.
    in_PosizionatoreSW.i64_diToleranceWindow =  0;  //      Finestra di Tolleranza
    //
    in_PosizionatoreSW.f_MaximumSpeed_x100_FW = 25.0;       // % of "i32_Max_Speed"
    in_PosizionatoreSW.f_MaximumSpeed_x100_BW = 25.0;       //
    in_PosizionatoreSW.f_ServoLockSpeed_x100_FW =   5.0;    //
    in_PosizionatoreSW.f_ServoLockSpeed_x100_BW =   5.0;    //

//    POS_MotionScan.attach_us    (&Motion_tScan, 2000);      // LA:  Scansione Motion @2ms

//    PWM_SetOut.attach_us  (&PWM____tScan, 100);             //      Scansione base PWM @100us  Ok
//    PWM_SetOut.attach_us  (&PWM____tScan, 50);              //      Scansione base PWM @50us  Ok
//    PWM_SetOut.attach_us  (&PWM____tScan, 30);              //      Scansione base PWM @30us  Ok
//    PWM_SetOut.attach_us  (&PWM____tScan, 25);              //      Scansione base PWM @25us  No (al pelo ...)
//    PWM_SetOut.attach_us  (&PWM____tScan, 10);              //      Scansione base PWM @10us  No (al pelo ...)
//    PWM_SetOut.attach_us  (&PWM____tScan, 20);              //      Scansione base PWM @20us  No

//  PWM_SetOut.attach_us  (&PWM____tScan, 40);              //      Scansione base PWM @40us,   Duty Cycle 4ms, 0- 100%
//    PWM_SetOut.attach_us  (&PWM____tScan, 100);              //      Scansione base PWM @40us,   Duty Cycle 5ms, 0- 100%

    PWM_PB3.period_us(100);         // LA:  TimeBase is 100us

  #define RED     0xf800            //  1111 1000 0000 0000
  #define GREEN   0x07e0            //  0000 0111 1110 0000
  #define BLUE    0x001f            //  0000 0000 0001 1111
  #define BLACK   0x0000            //  0000 0000 0000 0000
  #define YELLOW  0xffe0            //  1111 1111 1110 0000
  #define WHITE   0xffff            //  1111 1111 1111 1111

  #define CYAN        0x07ff        //  0000 0111 1111 1111
  #define BRIGHT_RED  0xf810        //  1111 1000 0001 0000
  #define GRAY1       0x8410        //  1000 0100 0001 0000
  #define GRAY2       0x4208        //  0100 0010 0000 1000

// LA:  Color RGB Component(s)
//      ======================
//
//  RED     0000 1000 0000 0000     min     0x0800  02048
//          1111 1000 0000 0000     max     0xf800  63488
//
//  GREEN   0000 0000 0010 0000     min     0x0020  00032
//          0000 0111 1110 0000     max     0x07e0  02016
//
//  BLUE    0000 0000 0000 0001     min     0x0001  00001
//          0000 0000 0001 1111     max     0x001f  00031
//
//  La componente ROSSA ha  5 bit di escursione (0.. 31),
//  La componente VERDE ha  6 bit di escursione (0.. 63),
//  La componente BLU ha    5 bit di escursione (0.. 31),
//
//  Le componenti RGB di "Color" sono quindi scritte negli appropriati registri come segue:
//
//  writeReg(RED,   (Color & 0xf800) >> 11);
//  writeReg(GREEN, (Color & 0x07e0) >> 5);
//  writeReg(BLUE,  (Color & 0x001f));
//

//    LCM_ClearScreen (GRAY1);
//    LCM_ClearScreen (BLACK);
//    LCM_ClearScreen (GRAY2);

    char StringText[MAX_CHAR_PER_LINE + 1];  // don't forget the /0 (end of string)
//    char StringText2[MAX_CHAR_PER_LINE + 1];
//    char StringText3[MAX_CHAR_PER_LINE + 1];

    uint16_t    ui16_TestColor = 0x0000;
    uint16_t    ui16_TestStep = 0x0000;
    //
    uint16_t    ui16_R = 0x00;
    uint16_t    ui16_G = 0x00;
    uint16_t    ui16_B = 0x00;

    while   (ui16_TestStep < 32) {

        ui16_TestColor =    Scale2RGBColor  (ui16_R, ui16_G, ui16_B);
        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %04x %04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);
        sprintf (StringText,
                "R:%02x G:%02x B:%02x ", ui16_R, ui16_G, ui16_B);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 5), StringText);
//        delay (500);

        ui16_R++;
        ui16_G++;
        ui16_B++;
//        ui16_TestColor +=   0x0841;
        ui16_TestStep ++;
    }
    delay (2500);

/*
    ui16_TestColor = 0x0000;
    ui16_TestStep = 0x0000;
    while   (ui16_TestStep < 32) {

        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %#04x %#04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);

//      ui16_TestColor +=   0x0841;
        ui16_TestColor +=   0x0001;
        ui16_TestStep ++;
    }

    ui16_TestColor = 0x0000;
    ui16_TestStep = 0x0000;
    while   (ui16_TestStep < 32) {

        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %#04x %#04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);

//      ui16_TestColor +=   0x0841;
        ui16_TestColor +=   0x0040;
        ui16_TestStep ++;
    }

    ui16_TestColor = 0x0000;
    ui16_TestStep = 0x0000;
    while   (ui16_TestStep < 32) {

        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %#04x %#04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);

//      ui16_TestColor +=   0x0841;
        ui16_TestColor +=   0x0800;
        ui16_TestStep ++;
    }

    ui16_TestColor = 0x0000;
    ui16_TestStep = 0x0000;
    while   (ui16_TestStep < 32) {

        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %#04x %#04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);

//      ui16_TestColor +=   0x0841;
        ui16_TestColor +=   0x0041;
        ui16_TestStep ++;
    }

    ui16_TestColor = 0x0000;
    ui16_TestStep = 0x0000;
    while   (ui16_TestStep < 32) {

        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %#04x %#04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);

//      ui16_TestColor +=   0x0841;
        ui16_TestColor +=   0x0840;
        ui16_TestStep ++;
    }

    ui16_TestColor = 0x0000;
    ui16_TestStep = 0x0000;
    while   (ui16_TestStep < 32) {

        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %#04x %#04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);

//      ui16_TestColor +=   0x0841;
        ui16_TestColor +=   0x0801;
        ui16_TestStep ++;
    }

    delay (5000);
*/
/*
    LCM_ClearScreen (0x07e0);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x07e0");
    delay (1000);
    LCM_ClearScreen (0x07c0);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x07c0");
    delay (1000);
    LCM_ClearScreen (0x07e0);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x07e0");
    delay (1000);
    LCM_ClearScreen (0x07c0);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x07c0");
    delay (1000);

    LCM_ClearScreen (0x0000);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x0000");
    delay (1000);
    LCM_ClearScreen (0x0020);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x0020");
    delay (1000);
    LCM_ClearScreen (0x0040);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x0040");
    delay (1000);
    LCM_ClearScreen (0x0020);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x0020");
    delay (1000);
    LCM_ClearScreen (0x0040);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x0040");
    delay (1000);
    LCM_ClearScreen (0x0000);
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), "0x0000");
    delay (1000);

*/
    ui16_TestColor =    Scale2RGBColor  (ui16_R, ui16_G, ui16_B);
    LCM_SetTextColor    (
                        Scale2RGBColor  (0, 0, 0),
                        Scale2RGBColor  (31, 31, 31)
                        );
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 0), "You Start Me Up ...");

    while   (1) {
    static int32_t  Pulses_Prec;
    static uint32_t ms_0003_prec;
    int32_t i32_Pulses;

        i32_Pulses =    Stabilus322699.getPulses();

        PosizionatoreSW (in_PosizionatoreSW, out_PosizionatoreSW);
        PWM_PB3.pulsewidth_us(((float)i32_Pulses/ (float)5000.0)* (float)100.0);      //      0.. 100us ->   0.. 100%

        // LA:  Wedge 4 LCDRefresh
        if  (
                (i32_Pulses !=  Pulses_Prec)
            ) {
            sprintf (StringText,
                    "Pulses: %d     ", i32_Pulses);
            LCM_SetTextColor    (Scale2RGBColor  (0, 0, 31), Scale2RGBColor  (31, 31, 0));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 1), StringText);
        }

        if  (out_PosizionatoreSW.ui32_PassedActual_ms != ms_0003_prec) {
            sprintf (StringText,
                    "PassedActual_ms: %d     ", out_PosizionatoreSW.ui32_PassedActual_ms);
            LCM_SetTextColor    (Scale2RGBColor  (0, 31, 0), Scale2RGBColor  (31, 0, 31));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 2), StringText);
            ms_0003_prec = out_PosizionatoreSW.ui32_PassedActual_ms;
        }
//        StabilusMenu (0, 0, out_PosizionatoreSW.ui32_PassedActual_ms, i32_Pulses);
    }
}
