
//Warning: Incompatible redefinition of macro "MBED_RAM_SIZE"  in "tmp/HU5Hqj", Line: 39, Col: 10
#ifndef MBED_RAM_SIZE
#define MBED_RAM_SIZE 0x00018000
#endif

//#include "mbed.h"
#include "QEI.h"
#include "SWPos.h"

#include "Timers.h"
//#include "Menu.h"
#include "Eeprom.h"
//#include "main.h"
//#include "app_config.h"

/*!
 * \brief Define IO for Unused Pin
 */
//DigitalOut  F_CS    (D6);               // MBED description of pin
//DigitalOut  SD_CS   (D8);               // MBED description of pin

DigitalIn   userButton  (USER_BUTTON);

AnalogIn    adc_temp    (ADC_TEMP);
AnalogIn    adc_vref    (ADC_VREF);
AnalogIn    adc_vbat    (ADC_VBAT);

//  PWM
//  ===
//
//PwmOut PWM_PB3(PWM_OUT);       // LA:  PWM_OUT = D3 = PB_3

//  Motion
//  ======
//
//Ticker POS_MotionScan;                              //

QEI Stabilus322699  (PA_1, PA_0, NC, 100, QEI::X4_ENCODING);
//
in_sPosizionatoreSW    in_PosizionatoreSW;
out_sPosizionatoreSW   out_PosizionatoreSW;

//  LCD Display
//  ===========
//
//Ticker LCD_RefreshViews;                            //

//extern void    StabilusMenu   (uint32_t, uint32_t, int64_t);                 // LA:  Prototype ...

void    FactoryReset    (void) {
    EepromFactoryReset( );
    HAL_NVIC_SystemReset( );
}

/*
void    LCD____tScan (void) {
//    StabilusMenu (out_PosizionatoreSW.ui32_PreviousStep_ms, out_PosizionatoreSW.ui32_ActualStepSampled_ms, out_PosizionatoreSW.ui32_PassedActual_ms);
}


void    Motion_tScan (void) {
    PosizionatoreSW (in_PosizionatoreSW, out_PosizionatoreSW);
}
*/

//  =======
//  =======
//  Main(s)
//  =======
//  =======
//
int main    (void){
//int32_t i32_Pulses;
//    F_CS =  1;          // LA:  HW Initialization InProgress 
//    SD_CS = 1;          // LA:  HW Initialization InProgress 
//    BoardLED3 = 1;

    EepromInit();       // LA:  Inizializza la EEProm
    TimersInit();       // LA:  Parte il Timer a 1ms

    // LA:  FactoryReset se "userButton" premuto all'avvio
    //
    if  (userButton == 0) {
        FactoryReset();
    }

    MenuInit();                                             // LA:  Inizializza il Display
//    LCD_RefreshViews.attach_us  (&LCD____tScan, 250000);    //      Scansione LCD @100ms

    // LA:  Motion (1st) Setup
    //
    in_PosizionatoreSW.b_AxisPowered =  false;
    in_PosizionatoreSW.b_ACPos_Homed =  false;
    in_PosizionatoreSW.i32_Max_Speed =  1024;       // [ui]
    in_PosizionatoreSW.i32_ZeroSpeed =  0;          //

    in_PosizionatoreSW.b_JogMode =  false;
    in_PosizionatoreSW.b_JogFW =    false;
    in_PosizionatoreSW.b_JogBW =    false;
    in_PosizionatoreSW.i32_JogAccel_ms =    500;    // [ms]
    in_PosizionatoreSW.i32_JogDecel_ms =    250;    //
    //
    in_PosizionatoreSW.f_JogSpeed_x100_FW = 25.0;   // % of "i32_Max_Speed"
    in_PosizionatoreSW.f_JogSpeed_x100_BW = 25.0;   //

    in_PosizionatoreSW.b_ServoLock =    false;
    in_PosizionatoreSW.rtServoLock_Q =  false;
    //
    in_PosizionatoreSW.i64_TargetPosition = 0;      // [ui]
    in_PosizionatoreSW.i64_ActualPosition = 0;      //
    in_PosizionatoreSW.i64_AccelerationWindow = 0;  // LA:  Spazio concesso all'accelerazione.
    in_PosizionatoreSW.i64_DecelerationWindow = 0;  //      Spazio concesso alla decelerazione, è prioritario rispetto all'accelerazione.
    in_PosizionatoreSW.i64_diToleranceWindow =  0;  //      Finestra di Tolleranza
    //
    in_PosizionatoreSW.f_MaximumSpeed_x100_FW = 25.0;       // % of "i32_Max_Speed"
    in_PosizionatoreSW.f_MaximumSpeed_x100_BW = 25.0;       //
    in_PosizionatoreSW.f_ServoLockSpeed_x100_FW =   5.0;    //
    in_PosizionatoreSW.f_ServoLockSpeed_x100_BW =   5.0;    //

//    POS_MotionScan.attach_us    (&Motion_tScan, 2000);      // LA:  Scansione Motion @2ms

//    PWM_SetOut.attach_us  (&PWM____tScan, 100);             //      Scansione base PWM @100us  Ok
//    PWM_SetOut.attach_us  (&PWM____tScan, 50);              //      Scansione base PWM @50us  Ok
//    PWM_SetOut.attach_us  (&PWM____tScan, 30);              //      Scansione base PWM @30us  Ok
//    PWM_SetOut.attach_us  (&PWM____tScan, 25);              //      Scansione base PWM @25us  No (al pelo ...)
//    PWM_SetOut.attach_us  (&PWM____tScan, 10);              //      Scansione base PWM @10us  No (al pelo ...)
//    PWM_SetOut.attach_us  (&PWM____tScan, 20);              //      Scansione base PWM @20us  No

//  PWM_SetOut.attach_us  (&PWM____tScan, 40);              //      Scansione base PWM @40us,   Duty Cycle 4ms, 0- 100%
//    PWM_SetOut.attach_us  (&PWM____tScan, 100);              //      Scansione base PWM @40us,   Duty Cycle 5ms, 0- 100%

//    PWM_PB3.period_us(100);         // LA:  TimeBase is 100us
//    PWM_PB3.pulsewidth_us(50);      //      0.. 100us ->   0.. 100%

    while   (1) {
//        int32_t i32_Pulses;
//        i32_Pulses =    Stabilus322699.getPulses();

        // LA:  Wedge 4 LCDRefresh
        StabilusMenu (out_PosizionatoreSW.ui32_PreviousStep_ms, out_PosizionatoreSW.ui32_ActualStepSampled_ms, out_PosizionatoreSW.ui32_PassedActual_ms, Stabilus322699.getPulses());
//        StabilusMenu (0, 1, 2, i32_Pulses);
//        StabilusMenu (0, 1, i32_Pulses);
//        StabilusMenu (0, 0, 0); // i32_Pulses);
//        StabilusMenu (); // i32_Pulses);
//        StabilusMenu (1); // i32_Pulses);

/*
        PWM_PB3 =  PWM_PB3+ (float)0.01;
        wait_ms(10);

        if  (PWM_PB3 >= (float)1.0)
            PWM_PB3 = 0;
*/
    }
}


/*
bool    PWM_0000    (uint32_t   ui32_Duty_x100) {
static uint32_t ui32_PWM_Base;

    if  (ui32_PWM_Base >= 100)
        ui32_PWM_Base = 0;
    else
        ui32_PWM_Base ++;

    if  (
            (ui32_Duty_x100 > 0) &&
            (ui32_Duty_x100 <= 100) &&
            (ui32_PWM_Base <= ui32_Duty_x100)
        )
        return  (true);
    else
        return  (false);
}

void    PWM____tScan (void) {
    PWM =   PWM_0000 (50);
}
*/
