
#include <stdio.h>
#include "mbed.h"
//#include "QEI.h"

#include "Menu.h"
#include "DisplayDriver.h"
#include "Eeprom.h"
#include "main.h"
#include "app_config.h"

/*!
 * \brief Maximum character count on the same line with function DrawText
 * This include needed space for the outline (at the begin and the end of line).
 * MAX_CHAR_PER_BTN is the same, but for a button.
 */
#define MAX_CHAR_PER_LINE       28

/*!
 * \brief Bitmap of Semtech Logo stored here (copied from a C file).
 */
extern uint8_t SemtechLogo[];

/*!
 * \brief This ticker give the rythme to check X and Y coordinates of activated
 * touched region (if pressed). CheckScreenFlag keep the status if Touchscreen
 * has been checked or not, until checked.
 */
//Ticker CheckScreenTouch;
volatile bool CheckScreenFlag = false;

/*!
 * \brief This ticker give the rythme to refresh a page when continuous info
 * has to be printed in the same page.
 */
//Ticker CheckPageRefresh;
volatile bool PageRefresh = false;

/*!
 * \brief This ticker give the rythme to avoid quick menu change
 */
//Ticker DebouncedScreenTouch;
volatile bool ScreenBeenDebounced = false;

/*!
 * \brief List og graphical object in the application.
 */
enum MenuObjectsId
{
    PAGE_BORDER = 0,
    TITLE_LINE,
    TITLE_TEXT,
    FIRM_LOGO,
    BTN0_BORDER,       // to accord with DrawActiveButton( ), each button should
    BTN0_MENU_TEXT,    // have consecutively MENU_TEXT (full large text),
    BTN0_LABEL_TEXT,   // LABEL_TEXT (left side of the button) and VALUE_TEXT
    BTN0_VALUE_TEXT,   // (right side of the button).
    BTN1_BORDER,
    BTN1_MENU_TEXT,
    BTN1_LABEL_TEXT,
    BTN1_VALUE_TEXT,
    BTN2_BORDER,
    BTN2_MENU_TEXT,
    BTN2_LABEL_TEXT,
    BTN2_VALUE_TEXT,
    BTN3_BORDER,
    BTN3_MENU_TEXT,
    BTN3_LABEL_TEXT,
    BTN3_VALUE_TEXT,
    BTN4_BORDER,
    BTN4_MENU_TEXT,
    BTN4_LABEL_TEXT,
    BTN4_VALUE_TEXT,
    BTN5_BORDER,
    BTN5_MENU_TEXT,
    BTN5_LABEL_TEXT,
    BTN5_VALUE_TEXT,
    BTN6_BORDER,
    BTN6_MENU_TEXT,
    BTN6_LABEL_TEXT,
    BTN6_VALUE_TEXT,
    BTN7_BORDER,
    BTN7_MENU_TEXT,
    BTN7_LABEL_TEXT,
    BTN7_VALUE_TEXT,
    BTN8_BORDER,
    BTN8_MENU_TEXT,
    BTN9_BORDER,
    BTN9_MENU_TEXT,
    LINE0_TEXT,
    LINE1_TEXT,
    LINE2_TEXT,
    LINE2_COL0_TEXT,
    LINE2_COL1_TEXT,
    LINE3_TEXT,
    LINE3_COL0_TEXT,
    LINE3_COL1_TEXT,
    LINE3_COL2_TEXT,
    LINE4_TEXT,         // to accord with DrawText( ), each text line should
    LINE4_COL0_TEXT,    // have consecutively TEXT (full large text),
    LINE4_COL1_TEXT,    // COL0_TEXT (left side of the line), COL1_TEXT (center
    LINE4_COL2_TEXT,    // region of the line) and COL2_TEXT (right side of the
    LINE5_COL0_TEXT,    // line). COL0..2 are optionals if doesn't exist.
    LINE5_COL1_TEXT,
    LINE5_COL2_TEXT,
    LINE6_COL0_TEXT,
    LINE6_COL1_TEXT,
    LINE6_COL2_TEXT,
    LINE7_COL0_TEXT,
    LINE7_COL1_TEXT,
    LINE7_COL2_TEXT,
    LINE8_COL0_TEXT,
    LINE8_COL1_TEXT,
    LINE9_COL0_TEXT,
    LINE9_COL1_TEXT,
    RNG_DIST_TEXT,
    RNG_DIST_CIRCLE,
    RNG_DS1_TEXT,
    RNG_DS2_TEXT,
    RNG_DS3_TEXT,
    RNG_DS4_TEXT,
    RNG_DS5_TEXT,
    RNG_DS0_LINE,
    RNG_DS1_LINE,
    RNG_DS2_LINE,
    RNG_DS3_LINE,
    RNG_DS4_LINE,
    RNG_DS5_LINE,
    RNG_MST_SCR,
};
#define GRAPH_OBJECTS_COUNT     80
GraphObject_t MenuObjects[GRAPH_OBJECTS_COUNT] =
{
//  (Id,                Type,           Xpos,   Ypos,   Height, Width,  LineW,  BackColor,  FrontColor,     DoFill, FillCol,    Source,         TouchActive}
    {PAGE_BORDER,       GO_RECTANGLE,   0,      0,      320,    240,    1,      BACK_COLOR, PAGE_COLOR,     false,  NULL,       NULL,           false},
    {TITLE_LINE,        GO_LINE,        0,      30,     1,      240,    1,      BACK_COLOR, PAGE_COLOR,     false,  NULL,       NULL,           false},
    {TITLE_TEXT,        GO_TEXT,        15,     9,      NULL,   208,    1,      BACK_COLOR, WHITE,          false,  NULL,       NULL,           false},
    {FIRM_LOGO,         GO_IMAGE,       20,     37,     95,     215,    1,      BACK_COLOR, WHITE,          false,  NULL,       SemtechLogo,    false},
    {BTN0_BORDER,       GO_RECTANGLE,   10,     40,     30,     106,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN0_MENU_TEXT,    GO_TEXT,        15,     48,     NULL,   96,     1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN0_LABEL_TEXT,   GO_TEXT,        15,     48,     NULL,   32,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN0_VALUE_TEXT,   GO_TEXT,        47,     48,     NULL,   64,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN1_BORDER,       GO_RECTANGLE,   10,     75,     30,     222,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN1_MENU_TEXT,    GO_TEXT,        15,     83,     NULL,   200,    1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN1_LABEL_TEXT,   GO_TEXT,        15,     83,     NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN1_VALUE_TEXT,   GO_TEXT,        79,     83,     NULL,   152,    1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN2_BORDER,       GO_RECTANGLE,   10,     110,    30,     222,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN2_MENU_TEXT,    GO_TEXT,        15,     118,    NULL,   200,    1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN2_LABEL_TEXT,   GO_TEXT,        15,     118,    NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN2_VALUE_TEXT,   GO_TEXT,        79,     118,    NULL,   152,    1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN3_BORDER,       GO_RECTANGLE,   10,     145,    30,     222,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN3_MENU_TEXT,    GO_TEXT,        15,     153,    NULL,   200,    1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN3_LABEL_TEXT,   GO_TEXT,        15,     153,    NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN3_VALUE_TEXT,   GO_TEXT,        79,     153,    NULL,   152,    1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN4_BORDER,       GO_RECTANGLE,   10,     180,    30,     222,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN4_MENU_TEXT,    GO_TEXT,        15,     188,    NULL,   200,    1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN4_LABEL_TEXT,   GO_TEXT,        15,     188,    NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN4_VALUE_TEXT,   GO_TEXT,        79,     188,    NULL,   152,    1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN5_BORDER,       GO_RECTANGLE,   10,     215,    30,     222,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN5_MENU_TEXT,    GO_TEXT,        15,     223,    NULL,   200,    1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN5_LABEL_TEXT,   GO_TEXT,        15,     223,    NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN5_VALUE_TEXT,   GO_TEXT,        79,     223,    NULL,   152,    1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN6_BORDER,       GO_RECTANGLE,   10,     250,    30,     222,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN6_MENU_TEXT,    GO_TEXT,        15,     258,    NULL,   200,    1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN6_LABEL_TEXT,   GO_TEXT,        15,     258,    NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN6_VALUE_TEXT,   GO_TEXT,        79,     258,    NULL,   152,    1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN7_BORDER,       GO_RECTANGLE,   10,     285,    30,     222,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN7_MENU_TEXT,    GO_TEXT,        15,     293,    NULL,   200,    1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN7_LABEL_TEXT,   GO_TEXT,        15,     293,    NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {BTN7_VALUE_TEXT,   GO_TEXT,        79,     293,    NULL,   152,    1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {BTN8_BORDER,       GO_RECTANGLE,   125,    285,    30,     107,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN8_MENU_TEXT,    GO_TEXT,        130,    293,    NULL,   96,     1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {BTN9_BORDER,       GO_RECTANGLE,   125,    40,     30,     107,    1,      BACK_COLOR, BUTTON_BORDER,  false,  NULL,       NULL,           false},
    {BTN9_MENU_TEXT,    GO_TEXT,        130,    48,     NULL,   96,     1,      BACK_COLOR, MENU_TEXT,      false,  NULL,       NULL,           false},
    {LINE0_TEXT,        GO_TEXT,        5,      80,     NULL,   232,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE1_TEXT,        GO_TEXT,        5,      100,    NULL,   232,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE2_TEXT,        GO_TEXT,        5,      120,    NULL,   232,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE2_COL0_TEXT,   GO_TEXT,        5,      120,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE2_COL1_TEXT,   GO_TEXT,        110,    120,    NULL,   56,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE3_TEXT,        GO_TEXT,        5,      140,    NULL,   232,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE3_COL0_TEXT,   GO_TEXT,        5,      140,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE3_COL1_TEXT,   GO_TEXT,        110,    140,    NULL,   56,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE3_COL2_TEXT,   GO_TEXT,        170,    140,    NULL,   64,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE4_TEXT,        GO_TEXT,        5,      160,    NULL,   232,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE4_COL0_TEXT,   GO_TEXT,        5,      160,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE4_COL1_TEXT,   GO_TEXT,        110,    160,    NULL,   56,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE4_COL2_TEXT,   GO_TEXT,        170,    160,    NULL,   64,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE5_COL0_TEXT,   GO_TEXT,        5,      180,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE5_COL1_TEXT,   GO_TEXT,        110,    180,    NULL,   56,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE5_COL2_TEXT,   GO_TEXT,        170,    180,    NULL,   64,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE6_COL0_TEXT,   GO_TEXT,        5,      200,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE6_COL1_TEXT,   GO_TEXT,        110,    200,    NULL,   56,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE6_COL2_TEXT,   GO_TEXT,        170,    200,    NULL,   64,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE7_COL0_TEXT,   GO_TEXT,        5,      220,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE7_COL1_TEXT,   GO_TEXT,        110,    220,    NULL,   56,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE7_COL2_TEXT,   GO_TEXT,        170,    220,    NULL,   64,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE8_COL0_TEXT,   GO_TEXT,        5,      240,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE8_COL1_TEXT,   GO_TEXT,        110,    240,    NULL,   56,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {LINE9_COL0_TEXT,   GO_TEXT,        5,      260,    NULL,   104,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {LINE9_COL1_TEXT,   GO_TEXT,        110,    260,    NULL,   56,     1,      BACK_COLOR, TEXT_VALUE,     false,  NULL,       NULL,           false},
    {RNG_DIST_TEXT,     GO_TEXT,        63,     75,     NULL,   120,    1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {RNG_DIST_CIRCLE,   GO_CIRCLE,      175,    270,    10,     10,     1,      BACK_COLOR, GRAY1,          true,   GRAY1,      NULL,           false},
    {RNG_DS1_TEXT,      GO_TEXT,        188,    230,    NULL,   40,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {RNG_DS2_TEXT,      GO_TEXT,        188,    198,    NULL,   40,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {RNG_DS3_TEXT,      GO_TEXT,        188,    166,    NULL,   40,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {RNG_DS4_TEXT,      GO_TEXT,        188,    134,    NULL,   40,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {RNG_DS5_TEXT,      GO_TEXT,        188,    102,    NULL,   40,     1,      BACK_COLOR, TEXT_COLOR,     false,  NULL,       NULL,           false},
    {RNG_DS0_LINE,      GO_LINE,        185,    110,    160,    1,      1,      BACK_COLOR, CIRCLE_FCOLOR,  false,  NULL,       NULL,           false},
    {RNG_DS1_LINE,      GO_LINE,        183,    238,    1,      5,      1,      BACK_COLOR, CIRCLE_FCOLOR,  false,  NULL,       NULL,           false},
    {RNG_DS2_LINE,      GO_LINE,        183,    206,    1,      5,      1,      BACK_COLOR, CIRCLE_FCOLOR,  false,  NULL,       NULL,           false},
    {RNG_DS3_LINE,      GO_LINE,        183,    174,    1,      5,      1,      BACK_COLOR, CIRCLE_FCOLOR,  false,  NULL,       NULL,           false},
    {RNG_DS4_LINE,      GO_LINE,        183,    142,    1,      5,      1,      BACK_COLOR, CIRCLE_FCOLOR,  false,  NULL,       NULL,           false},
    {RNG_DS5_LINE,      GO_LINE,        183,    110,    1,      5,      1,      BACK_COLOR, CIRCLE_FCOLOR,  false,  NULL,       NULL,           false},
    {RNG_MST_SCR,       GO_RECTANGLE,   1,      70,     214,    238,    1,      BACK_COLOR, BACK_COLOR,     false,  NULL,       NULL,           false},
};

/*!
 * \brief DrawText( ) need char* to display a text. It can display until
 * 3 different texts on the same line. To avoid recursive use of the same
 * ressource, 3 temporary string are declared.
 */
char StringText[MAX_CHAR_PER_LINE + 1];  // don't forget the /0 (end of string)
char StringText2[MAX_CHAR_PER_LINE + 1];
char StringText3[MAX_CHAR_PER_LINE + 1];

/*!
 * \brief CurrentPage store current displayed page (cf.: list of availlable
 * pages in Menu.h). PeviousPage is used only when navigate through "Radio
 * Config" to be able to restore the page before "Radio Congig", witch can be
 * PingPong, PER or START_PAGE. The goal is to speed menu navigation.
 */
//static uint8_t CurrentPage  = START_PAGE;
//static uint8_t PreviousPage = START_PAGE;

/*!
 * \brief In "Radio Config Freq", we can update the central frequency. To avoid 
 * keyboard, we use (+) et (-) keys. CurrentFreqBase is the offset to be applied
 * when we increase or decrease the frequency.
 */
//static FreqBase CurrentFreqBase = FB100K;

void MenuInit( void )
{
    DisplayDriverInit( );
    GraphObjectDraw( &( MenuObjects[PAGE_BORDER] ), NULL, false, false );
//    GraphObjectDraw( &( MenuObjects[TITLE_LINE] ), NULL, false, false );
//    MenuSetPage( START_PAGE );

//    CheckScreenTouch.attach_us( &CheckScreen, 100000 );     // every 100 ms

    // Page Utilities only for GPS and proximity sensor :
//    CheckPageRefresh.attach_us( &CheckRefresh, 1000000 );   // every 1 s
}

extern  DigitalIn   userButton;
//
extern  AnalogIn    adc_temp;
extern  AnalogIn    adc_vref;
extern  AnalogIn    adc_vbat;
//
//extern  QEI Stabilus322699;

//void    StabilusMenu    (uint32_t ms_0001, uint32_t ms_0002, uint32_t ms_0003, int32_t i32_Pulses) {
//void    StabilusMenu    (uint32_t ms_0001, uint32_t ms_0002, int32_t i32_Pulses) {
//void    StabilusMenu    (int32_t i32_Pulses) {
//void    StabilusMenu    (void) {
void    StabilusMenu    (uint32_t ms_0001, uint32_t ms_0002, uint32_t ms_0003, int32_t i32_Pulses) {
//int32_t i32_Pulses;

static bool InProgress =    false;
uint8_t graphObjectTouched = 0xFF;

    if  (InProgress)
        return;
    else {
    static uint32_t ms_0001_prec;
    static uint32_t ms_0002_prec;
    static uint32_t ms_0003_prec;
    static bool PBPushed_prec;
    
    static bool Touched_Prec;
    static int32_t  Pulses_Prec;
    
    static uint16_t  x_Prec;
    static uint16_t  y_Prec;
    
    uint16_t x, y = 0;
    bool touched = false;
    bool PBPushed = false;

        InProgress =    true;

        GraphObjectTouched  (MenuObjects,
                            GRAPH_OBJECTS_COUNT,
                            &graphObjectTouched);

        TouchedXYT (&x, &y, &touched);
        if  (
                (touched != Touched_Prec) ||
                (x != x_Prec) ||
                (y != y_Prec) ||
                (i32_Pulses !=  Pulses_Prec)
    //            (Stabilus322699.getPulses() != Pulses_Prec)
            ) {
            sprintf (StringText,
                    "Screen Touched: %d %d", touched, i32_Pulses);
            DrawText    (TITLE_TEXT, (uint8_t*)StringText, NULL , NULL);
    
            if  (touched == true) {
                sprintf (StringText,
                        "x: %d", x);
                DrawActiveButton    (BTN2_BORDER, (uint8_t*)StringText, NULL);
            
                sprintf (StringText,
        //                "Y: %d %f", y, adc_vref.read());
                        "Y: %d", y);
                DrawActiveButton    (BTN3_BORDER, (uint8_t*)StringText, NULL);
            }
            else {
                DrawActiveButton    (BTN2_BORDER, (uint8_t*) "No Touch ...", NULL);
                DrawActiveButton    (BTN3_BORDER, (uint8_t*) "No Touch ...", NULL);
            }
    
            Touched_Prec =  touched;
            x_Prec =    x;
            y_Prec =    y;
            //
            Pulses_Prec =   i32_Pulses;
        }

        if  (ms_0001 != ms_0001_prec) {
            sprintf (StringText,
        //            "adc_temp: %f", (adc_temp.read()* 100));
                    "PreviousStep_ms: %d", ms_0001);
            DrawActiveButton    (BTN4_BORDER, (uint8_t*)StringText, NULL);
            ms_0001_prec = ms_0001;
        }
    
        if  (ms_0002 != ms_0002_prec) {
            sprintf (StringText,
        //            "adc_vref: %f", (adc_vref.read()));
                    "StepSampled_ms : %d", ms_0002);
            DrawActiveButton    (BTN5_BORDER, (uint8_t*)StringText, NULL);
            ms_0002_prec = ms_0002;
        }
    
        if  (ms_0003 != ms_0003_prec) {
            sprintf (StringText,
        //            "adc_vbat: %f", (adc_vbat.read()));
                    "PassedActual_ms: %d", ms_0003);
            DrawActiveButton    (BTN6_BORDER, (uint8_t*)StringText, NULL);
            ms_0003_prec = ms_0003;
        }

        PBPushed = userButton;
        if  (PBPushed != PBPushed_prec) {
            sprintf (StringText,
                    "PB Released: %d", PBPushed);
            DrawActiveButton    (BTN7_BORDER, (uint8_t*)StringText, NULL);
            PBPushed_prec = PBPushed;
        }
        //
//        StabilusMainPage    (graphObjectTouched, ms_0001, ms_0002, ms_0003, i32_Pulses);
        InProgress =    false;
    }
}

/*!
 * \brief Draw button
 *
 * \param [in]  buttonId      Id of the button to draw
 * \param [in]  *text1        Text to draw as label
 * \param [in]  *text2        Text to draw as value
 */
void DrawActiveButton( uint8_t buttonId, uint8_t* text1, uint8_t* text2 ){
    GraphObjectDraw( &( MenuObjects[buttonId] ), NULL, NULL, true );
    if( text2 == NULL )    {
        if( text1 != NULL )        {
            GraphObjectDraw( &( MenuObjects[buttonId + 1] ), text1, NULL, false );
        }
    }
    else    {
        if( text1 != NULL )        {
            GraphObjectDraw( &( MenuObjects[buttonId + 2] ), text1, NULL, false );
        }
        GraphObjectDraw( &( MenuObjects[buttonId + 3] ), text2, NULL, false );
    }
}

void ButtonChangeText( uint8_t buttonId, uint8_t* text1, uint8_t* text2 ){
    if( text2 == NULL )    {
        if( text1 != NULL )        {
            GraphObjectDraw( &( MenuObjects[buttonId + 1] ), text1, NULL, false );
        }
    }
    else    {
        if( text1 != NULL )        {
            GraphObjectDraw( &( MenuObjects[buttonId + 2] ), text1, NULL, false );
        }
        GraphObjectDraw( &( MenuObjects[buttonId + 3] ), text2, NULL, false );
    }
}

void RemoveButton( uint8_t buttonId ){
    GraphObjectClear( &( MenuObjects[buttonId] ), true );
}

void DrawText( uint8_t lineId, uint8_t* text0, uint8_t* text1, uint8_t* text2 ){
    if( text0 != NULL )    {
        GraphObjectDraw( &( MenuObjects[lineId] ), text0, NULL, false );
    }
    if( text1 != NULL )    {
        GraphObjectDraw( &( MenuObjects[lineId + 1] ), text1, NULL, false );
    }
    if( text2 != NULL )    {
        GraphObjectDraw( &( MenuObjects[lineId + 2] ), text2, NULL, false );
    }
}
