/*
  ______                              _
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2016 Semtech

Description: Main program

Maintainer: Gregory Cristian & Gilbert Menth
*/

#include "mbed.h"
#include "Timers.h"
#include "Menu.h"
#include "Eeprom.h"
//#include "GpsMax7.h"
//#include "SX9306.h"
#include "sx1280-hal.h"
#include "main.h"
#include "app_config.h"

/*!
 * \brief Define IO for Unused Pin
 */
DigitalOut F_CS( D6 );      // MBED description of pin
DigitalOut SD_CS( D8 );     // MBED description of pin
DigitalIn userButton( USER_BUTTON );

//void PrintCompileSupportMessage( void );

/*!
 * \brief Specify serial datarate for UART debug output
 */
//void baud( int baudrate )
//{
//    Serial s( USBTX, USBRX );
//    s.baud( baudrate );
//}

extern SX1280Hal Radio;

// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================

extern  bool    bTimeInRx;

// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================

void LedRED( uint8_t Status );
void LedGREEN( uint8_t Status );

extern  Ticker  tTimeInTx;          // LA:  Aggiunta, Tempo concesso alla Trasmissione
extern  bool    bTimeInTx;          // LA:  Aggiunta, True quando siamo in tempo concesso alla Tx, False a tempo Spirato.
extern  Ticker  tTimeInRx;          // LA:  Aggiunta, Tempo concesso alla ricezione dopo una Richiesta di Ranging evasa.
extern  bool    bTimeInRx;          // LA:  Aggiunta, True quando siamo in tempo concesso alla Rx, False a tempo Spirato.

void    pTimeInTxDone   (void);     // LA:  Allo scatenarsi del Ticker fa terminare il tempo concesso alla Trasmissione
void    pTimeInRxDone   (void);     // LA:  Allo scatenarsi del Ticker fa terminare il tempo concesso alla Ricezione

Ticker  tTime1sHandler;                         // LA:  Scansore Temporale (1s, 1000ms, 1000000us)
extern  void p1sWentPast (void);                // LA:  1s Operations Handler
Ticker  tLCDRefreshHandler;                     // LA:  Scansore Temporale LCD
extern  void pLCDRefreshTimeWentPast (void);    // LA:  1s Operations Handler

void InitializeDemoParameters   (uint8_t modulation);

// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================

bool    PageRefreshMaster = false;          // LA:  Aggiorna LCD, in RadioSLEEP, solo se serve
bool    bAddressedRxInProgress = false;     // LA:  Rx in COrso da dispositivo correttamente Indirizzato, la lascio finire

int main( )
{
//    bool    EEPChange = false;          // LA:  Aggiorna la EEP solo se serve

    F_CS = 1;
    SD_CS = 1;

  Eeprom.EepromData.DemoSettings.ModulationType = PACKET_TYPE_RANGING;
  Eeprom.EepromData.ModulationParams.PacketType = PACKET_TYPE_RANGING;
  Eeprom.EepromData.PacketParams.PacketType     = PACKET_TYPE_RANGING;

  Eeprom.EepromData.DemoSettings.ModulationParam1 = LORA_SF6;
  Eeprom.EepromData.DemoSettings.ModulationParam2 = LORA_BW_1600;
  Eeprom.EepromData.DemoSettings.ModulationParam3 = LORA_CR_4_5;

  Eeprom.EepromData.DemoSettings.PacketParam1    = 12; // PreambleLength
  Eeprom.EepromData.DemoSettings.PacketParam2    = LORA_PACKET_VARIABLE_LENGTH;
  Eeprom.EepromData.DemoSettings.PacketParam3    = 10; // PayloadLength
  Eeprom.EepromData.DemoSettings.PacketParam4    = LORA_CRC_ON;
  Eeprom.EepromData.DemoSettings.PacketParam5    = LORA_IQ_NORMAL;
  Eeprom.EepromData.DemoSettings.RngRequestCount = 60;
  Eeprom.EepromData.DemoSettings.RngFullScale    = 30;
//    Eeprom.EepromData.DemoSettings.RngAddress      = DEMO_RNG_ADDR_1;
  Eeprom.EepromData.DemoSettings.RngAntenna      = DEMO_RNG_ANT_1;
  Eeprom.EepromData.DemoSettings.RngUnit         = DEMO_RNG_UNIT_SEL_M;

  Eeprom.EepromData.DemoSettings.ModulationType = PACKET_TYPE_LORA;
  Eeprom.EepromData.ModulationParams.PacketType = PACKET_TYPE_LORA;
  Eeprom.EepromData.PacketParams.PacketType     = PACKET_TYPE_LORA;

  Eeprom.EepromData.DemoSettings.ModulationParam1 = LORA_SF10;
  Eeprom.EepromData.DemoSettings.ModulationParam2 = LORA_BW_1600;
  Eeprom.EepromData.DemoSettings.ModulationParam3 = LORA_CR_4_5;

  Eeprom.EepromData.DemoSettings.PacketParam1 = 12; // PreambleLength
  Eeprom.EepromData.DemoSettings.PacketParam2 = LORA_PACKET_VARIABLE_LENGTH;
  Eeprom.EepromData.DemoSettings.PacketParam3 = DEMO_MIN_PAYLOAD;
  Eeprom.EepromData.DemoSettings.PacketParam4 = LORA_CRC_ON;
  Eeprom.EepromData.DemoSettings.PacketParam5 = LORA_IQ_NORMAL;

  Eeprom.EepromData.DemoSettings.ModulationType = PACKET_TYPE_GFSK;
  Eeprom.EepromData.ModulationParams.PacketType = PACKET_TYPE_GFSK;
  Eeprom.EepromData.PacketParams.PacketType     = PACKET_TYPE_GFSK;

  Eeprom.EepromData.DemoSettings.ModulationParam1 = GFSK_BLE_BR_0_125_BW_0_3;
  Eeprom.EepromData.DemoSettings.ModulationParam2 = GFSK_BLE_MOD_IND_1_00;
  Eeprom.EepromData.DemoSettings.ModulationParam3 = RADIO_MOD_SHAPING_BT_1_0;

  Eeprom.EepromData.DemoSettings.PacketParam1 = PREAMBLE_LENGTH_32_BITS;
  Eeprom.EepromData.DemoSettings.PacketParam2 = GFSK_SYNCWORD_LENGTH_5_BYTE;
  Eeprom.EepromData.DemoSettings.PacketParam3 = RADIO_RX_MATCH_SYNCWORD_1;
  Eeprom.EepromData.DemoSettings.PacketParam4 = RADIO_PACKET_VARIABLE_LENGTH;
  Eeprom.EepromData.DemoSettings.PacketParam5 = DEMO_MIN_PAYLOAD;
  Eeprom.EepromData.DemoSettings.PacketParam6 = RADIO_CRC_3_BYTES;
  Eeprom.EepromData.DemoSettings.PacketParam7 = RADIO_WHITENING_ON;

  Eeprom.EepromData.DemoSettings.ModulationType = PACKET_TYPE_FLRC;
  Eeprom.EepromData.ModulationParams.PacketType = PACKET_TYPE_FLRC;
  Eeprom.EepromData.PacketParams.PacketType     = PACKET_TYPE_FLRC;

  Eeprom.EepromData.DemoSettings.ModulationParam1 = FLRC_BR_0_260_BW_0_3;
  Eeprom.EepromData.DemoSettings.ModulationParam2 = FLRC_CR_1_2;
  Eeprom.EepromData.DemoSettings.ModulationParam3 = RADIO_MOD_SHAPING_BT_1_0;

  Eeprom.EepromData.DemoSettings.PacketParam1 = PREAMBLE_LENGTH_32_BITS;
  Eeprom.EepromData.DemoSettings.PacketParam2 = FLRC_SYNCWORD_LENGTH_4_BYTE;
  Eeprom.EepromData.DemoSettings.PacketParam3 = RADIO_RX_MATCH_SYNCWORD_1;
  Eeprom.EepromData.DemoSettings.PacketParam4 = RADIO_PACKET_VARIABLE_LENGTH;
  Eeprom.EepromData.DemoSettings.PacketParam5 = DEMO_MIN_PAYLOAD;
  Eeprom.EepromData.DemoSettings.PacketParam6 = RADIO_CRC_3_BYTES;
  Eeprom.EepromData.DemoSettings.PacketParam7 = RADIO_WHITENING_OFF;

  Eeprom.EepromData.DemoSettings.Entity         = SLAVE;
  Eeprom.EepromData.DemoSettings.AntennaSwitch  = 0x00;
  Eeprom.EepromData.DemoSettings.RadioPowerMode = USE_DCDC;
  Eeprom.EepromData.DemoSettings.Frequency      = DEMO_CENTRAL_FREQ_PRESET1;
  Eeprom.EepromData.DemoSettings.TxPower        = DEMO_POWER_TX_MAX;
  Eeprom.EepromData.DemoSettings.MaxNumPacket   = 0x00; // infinite
  Eeprom.EepromData.DemoSettings.ModulationType = PACKET_TYPE_LORA;

  // LA:    Parametri attualmente in Uso
  //        ============================
  //
  Eeprom.EepromData.DemoSettings.TxPower =    -18;
  Eeprom.EepromData.DemoSettings.Entity = MASTER;
  Eeprom.EepromData.DemoSettings.ModulationType = PACKET_TYPE_RANGING;
  Eeprom.EepromData.ModulationParams.PacketType = PACKET_TYPE_RANGING;
  Eeprom.EepromData.PacketParams.PacketType = PACKET_TYPE_RANGING;
  Eeprom.EepromData.DemoSettings.ModulationParam1 =   LORA_SF5;
  Eeprom.EepromData.DemoSettings.ModulationParam2 =   LORA_BW_1600;
  Eeprom.EepromData.DemoSettings.ModulationParam3 =   LORA_CR_4_5;
  Eeprom.EepromData.DemoSettings.PacketParam1 =   12;     // PreambleLength
  Eeprom.EepromData.DemoSettings.PacketParam2 =   LORA_PACKET_VARIABLE_LENGTH;
  Eeprom.EepromData.DemoSettings.PacketParam3 =   10;     // PayloadLength
  Eeprom.EepromData.DemoSettings.PacketParam4 =   LORA_CRC_ON;
  Eeprom.EepromData.DemoSettings.PacketParam5 =   LORA_IQ_NORMAL;
  Eeprom.EepromData.DemoSettings.RngRequestCount =    80;        // LA:  Range Hops
  Eeprom.EepromData.DemoSettings.RngAntenna = DEMO_RNG_ANT_1;

//    InitDemoApplication( );       // LA:  Verificare
//    MenuInit( );                  // LA:  Verificare

// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================

    LedRED (0);
    LedGREEN (0);
    tTime1sHandler.detach ();
    tTime1sHandler.attach_us    (&p1sWentPast, 1000000);    // LA:  Any 1s
    tLCDRefreshHandler.detach ();
//    tLCDRefreshHandler.attach_us    (&pLCDRefreshTimeWentPast, 250000);    // LA:  Any 1/4s

    while   (true) {

        tTimeInTx.detach ();
        bTimeInTx = true;
        PageRefreshMaster = false;
        //
        while   (bTimeInTx) {
            LedRED (1);
            LedGREEN (0);

            if  (Eeprom.EepromData.DemoSettings.HoldDemo) {
                Eeprom.EepromData.DemoSettings.HoldDemo =   false;
            }
            PageRefreshMaster |=   (RunDemoApplicationRangingMaster());
        }
        LedRED (0);
        LedGREEN (0);
        StopDemoApplication ();

        // LA:  Tempo in "Sleep" virtuale
        //      =========================
        //      =========================
        //
        MenuSetMasterPage   (true);
        //
        //      =========================
        //      =========================
        // LA:  Tempo in "Sleep" virtuale

        tTimeInRx.detach ();
        bTimeInRx = true;
        bAddressedRxInProgress =    false;
        //
        while   (bTimeInRx ||
                bAddressedRxInProgress) {
            LedRED (0);
            LedGREEN (1);

            if  (Eeprom.EepromData.DemoSettings.HoldDemo) {
                Eeprom.EepromData.DemoSettings.HoldDemo =   false;
            }
            bAddressedRxInProgress =    (RunDemoApplicationRangingSlave());
        }
        LedRED (0);
        LedGREEN (0);
        StopDemoApplication ();

        // LA:  Tempo in "Sleep" virtuale
        //      =========================
        //      =========================
        //
        //  MenuSetMasterPage   (true);
        MenuSetSlavePage   (true);
        //
        //      =========================
        //      =========================
        // LA:  Tempo in "Sleep" virtuale

    }
}

// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================

//void    FactoryReset    (void) {
//    EepromFactoryReset( );
//    HAL_NVIC_SystemReset( );
//}

