/*
  ______                              _
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2016 Semtech

Description: Display demo menus and manage touch sensor.

Maintainer: Gregory Cristian & Gilbert Menth
*/

#include <stdio.h>
//#include "mbed.h"
#include "Menu.h"
//#include "DisplayDriver.h"
#include "Eeprom.h"
#include "DemoApplication.h"
#include "main.h"
#include "app_config.h"

/*!
 * \brief Maximum character count on the same line with function DrawText
 * This include needed space for the outline (at the begin and the end of line).
 * MAX_CHAR_PER_BTN is the same, but for a button.
 */
#define MAX_CHAR_PER_LINE       28

#define SCALE_LINE_COUNT        5
#define RANGING_FULLSCALE_MIN   10
#define RANGING_FULLSCALE_MAX   30000

/*!
 * \brief Bitmap of Semtech Logo stored here (copied from a C file).
 */
extern uint8_t SemtechLogo[];

void LedRED( uint8_t Status );
void LedGREEN( uint8_t Status );

// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
//

//extern double   dAverageDistanceCircularBuffer [];      // LA:  Definito in "DemoApplication.cpp" ...
extern uint8_t  ui8CBIndex;                             // LA:  Definito in "DemoApplication.cpp" ...

extern ActivePartner_t ActivePartnersList [];           // LA:  Numero Massimo di Partners "sostenibili"
extern AnsweringPartner_t AnsweringPartnersList [];     // LA:  Numero Massimo di Partners Rispondenti "sostenibili"

//
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================
// LA:  ========================================================================

/*!
 * \brief This ticker give the rythme to check X and Y coordinates of activated
 * touched region (if pressed). CheckScreenFlag keep the status if Touchscreen
 * has been checked or not, until checked.
 */
Ticker CheckScreenTouch;
volatile bool CheckScreenFlag = false;

/*!
 * \brief This ticker give the rythme to refresh a page when continuous info
 * has to be printed in the same page.
 */
Ticker CheckPageRefresh;
volatile bool PageRefresh = false;

/*!
 * \brief This ticker give the rythme to avoid quick menu change
 */
Ticker DebouncedScreenTouch;
volatile bool ScreenBeenDebounced = false;

void    MenuSetMasterPage   (bool Refresh) {
uint8_t iui8RngExtractIndex;
double  dRngExtractMin;
double  dRngExtractMax;
bool    bEnemyInRange;

    //      =========================================
    //      =========================================
    // LA:  Estrazione della Distanza dalla "Tabella"
    //      =========================================
    //      =========================================

    bEnemyInRange = false;
    dRngExtractMin =    18.5;
    dRngExtractMax =    0.0;

    for (iui8RngExtractIndex = 0; iui8RngExtractIndex < ciMaxActivePartners; iui8RngExtractIndex++) {
        if  ((AnsweringPartnersList[iui8RngExtractIndex].ui32Address > 0) &&
            (AnsweringPartnersList[iui8RngExtractIndex].dRngRawCircularBufferDistance > 0.1) &&
            (AnsweringPartnersList[iui8RngExtractIndex].dRngRawCircularBufferDistance < 18.5)) {
            bEnemyInRange = true;

            if  (AnsweringPartnersList[iui8RngExtractIndex].dRngRawCircularBufferDistance > dRngExtractMax)
                dRngExtractMax =    AnsweringPartnersList[iui8RngExtractIndex].dRngRawCircularBufferDistance;
            if  (AnsweringPartnersList[iui8RngExtractIndex].dRngRawCircularBufferDistance < dRngExtractMin)
                dRngExtractMin =    AnsweringPartnersList[iui8RngExtractIndex].dRngRawCircularBufferDistance;
        }
    }
    if  (bEnemyInRange) {
        Eeprom.EepromData.DemoSettings.RngDistance =    dRngExtractMin;
    }
    else {
        Eeprom.EepromData.DemoSettings.RngDistance =    18.5;
    }

    //      ==========================================================
    //      ==========================================================
    // LA:  LED x il Distanziamento Sociale (COVID Range output Color)
    //      ==========================================================
    //      ==========================================================
    //
    if  (Eeprom.EepromData.DemoSettings.RngDistance >= 2.5) {
//      MenuObjects[RNG_DIST_CIRCLE].FrontColor = GREEN;
//                LedRED (0);
//                LedGREEN (1);
    }
    else if ((Eeprom.EepromData.DemoSettings.RngDistance < 2.5) &&
            (Eeprom.EepromData.DemoSettings.RngDistance > 1.2)){
//      MenuObjects[RNG_DIST_CIRCLE].FrontColor = YELLOW;
//                LedRED (1);
//                LedGREEN (1);
    }
    else {
//      MenuObjects[RNG_DIST_CIRCLE].FrontColor = RED;
//                LedRED (1);
//                LedGREEN (0);
    }
}

void    MenuSetSlavePage   (bool Refresh) {

    //      =================================================================
    //      =================================================================
    // LA:  Palesamento del Buffer Circolare di Partners Attivi (Richiedenti)
    //      =================================================================
    //      =================================================================
    //
}
