/*
  ______                              _
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2016 Semtech

Description: EEPROM routines

Maintainer: Gregory Cristian & Gilbert Menth
*/

#include "mbed.h"
#include "string.h"
#include "Eeprom.h"
#include "Menu.h"
#include "DemoApplication.h"
#include "sx1280.h"

/*!
 * \brief Define address of Emulated EEPROM (in fact region of Flash)
 */
#if defined( TARGET_NUCLEO_L476RG )
#define DATA_EEPROM_BASE    ( ( uint32_t )0x0807F800U )
#define DATA_EEPROM_END     ( ( uint32_t )DATA_EEPROM_BASE + 2048 )
#elif defined( TARGET_NUCLEO_L152RE )
#define DATA_EEPROM_BASE    ( ( uint32_t )0x08080000U ) 
#define DATA_EEPROM_END     ( ( uint32_t )0x080807FFU )
#else
#error "Please define EEPROM base address and size for your board "
#endif

/*!
 * \brief Local copy of Eeprom.
 */
Eeprom_t Eeprom;
