#include "mbed.h"

struct in_sPosizionatoreSW {
    bool    b_AxisPowered;
    bool    b_ACPos_Homed;
    float   f_Max_Speed;
    float   f_ZeroSpeed;

    bool    b_JogMode;
    bool    b_JogFW;
    bool    b_JogBW;
    //
    int32_t     i32_JogAccel_ms;
    int32_t     i32_JogDecel_ms;
    //
    float   f_JogSpeed_x100_FW;             //      in_rJogSpeed%_FW
    float   f_JogSpeed_x100_BW;             //      in_rJogSpeed%_BW

    bool    b_ServoLock;
    bool    rtServoLock_Q;
    //
    int64_t     i64_TargetPosition;
    int64_t     i64_ActualPosition;
    int64_t     i64_AccelerationWindow;
    int64_t     i64_DecelerationWindow;
    int64_t     i64_diToleranceWindow;
    //
    float   f_ServoLockSpeed_x100_FW;       //      in_rServoLockSpeed%_FW
    float   f_ServoLockSpeed_x100_BW;       //      in_rServoLockSpeed%_BW
    float   f_MaximumSpeed_x100_FW;         // LA:  in_rMaximumSpeed%_FW
    float   f_MaximumSpeed_x100_BW;         // LA:  in_rMaximumSpeed%_BW
};

struct out_sPosizionatoreSW {
    int64_t i64_StartPosition;
    int64_t i64_Distance;

    bool    b_Accelerating;                   // LA:  bACPos_Accelerating
    bool    b_MaxSpeedReached;
    //
    bool    b_Decelerating;                   //      bACPos_Decelerating
    bool    b_InPosition;
    bool    b_InToleranceFW;
    bool    b_InToleranceBW;

    float   f_ATVSpeed;
    bool    b_ATVDirectionFW;
    bool    b_ATVDirectionBW;
    //
    bool    b_STW1_On;
    bool    b_STW1_NoCStop;
    bool    b_STW1_NoQStop;
    bool    b_STW1_Enable;

    // LA:  Disposizioni transitorie e finali
    //
    uint32_t    ui32_PreviousStep_ms;
    uint32_t    ui32_ActualStepSampled_ms;
    uint32_t    ui32_PassedActual_ms;
};

void    PosizionatoreSW (const in_sPosizionatoreSW &in, out_sPosizionatoreSW &out);
