
//Warning: Incompatible redefinition of macro "MBED_RAM_SIZE"  in "tmp/HU5Hqj", Line: 39, Col: 10
#ifndef MBED_RAM_SIZE
#define MBED_RAM_SIZE 0x00018000
#endif

#include "QEI.h"
#include "SWPos.h"

#include "Timers.h"
#include "Eeprom.h"

#define MAX_CHAR_PER_LINE   28
#define TEXT_ROW_SPACING    16
#define FONT_CHAR_WIDTH 8
#define FONT_CHAR_HEIGHT    16

#include "DisplayDriver.h"

void    LCM_ShowTactics(
                        int32_t i32_Pulses,
                        int32_t i32_ATVSpeed,
                        float f_ai0000_Aux,
                        float f_ai0001_Aux,
                        float f_ai0002_Aux,
                        float f_ai0003_Aux,
                        float f_ai0004_Aux,
                        float f_ai0005_Aux
                        );
static void SampleAndStore  (void);

Ticker  SampleTimer;                    // LA:  To Sample 1AI any ms
float   af_PlotSamples[240];            // LA:  "Horiz" Plot Array

uint16_t    aui16_PlotSamples[240];
uint16_t    aui16_PlotClears_Lo[240];
uint16_t    aui16_PlotClears_Hi[240];

// LA:  Theory of Operation
//      ===================
//
//  Il PWM funziona da sè in Interrupt
//  Il QEI funziona da sè in Interrupt
//  Se si creano dei Ticker (Che sono a loro volta interrupt(s)) è possibile che PWM e QEI perdano correlazione con l'HW.
//
//  PQM
//
//  Il rinfresco del Display e la gestione del motion vanno fatte il più frequentemente possibile ma fuori dal loop dei Ticker.
//  Con qst versione (LA0005, che termina un FORK (il successivo è LA0010) quanto detto sopra è FUNZIONANTE.
//  Questo messaggio è incluso nel "commitment"

/*!
 * \brief Define IO for Unused Pin
 */
//DigitalOut  F_CS    (D6);               // MBED description of pin
//DigitalOut  SD_CS   (D8);               // MBED description of pin

DigitalIn   userButton  (USER_BUTTON);
//
DigitalOut  rENA_Off    (PC_0);           // CN7.38 -    Power Enable Relay,            Power Disabled when true
DigitalOut  rDIR_FWD    (PC_1);           // CN7.36 -    Move Direction Relay Bridge,   Move FW(Extends) when true

AnalogIn    adc_temp    (ADC_TEMP);
AnalogIn    adc_vref    (ADC_VREF);
AnalogIn    adc_vbat    (ADC_VBAT);

AnalogIn    ADC12_IN9   (PA_4);             // STM32 PA4
AnalogIn    ADC12_IN15  (PB_0);             // STM32 PB0

//  PWM
//  ===
//
PwmOut PWM_PB3(PWM_OUT);       // LA:  PWM_OUT = D3 = PB_3

//  QEI
//  ===
//
QEI Stabilus322699  (PA_1, PA_0, NC, 100, QEI::X4_ENCODING);
//DigitalIn   Hall_A  (PA_1);
//DigitalIn   Hall_B  (PA_0);

//  Motion
//  ======
//
//Ticker POS_MotionScan;                              // LA:    Non uso un Ticker. Agisce sotto Interrupt e falsa la lettura QEI e la sincronicità del PWM
//
in_sPosizionatoreSW    in_PosizionatoreSW;
out_sPosizionatoreSW   out_PosizionatoreSW;

//  LCD Display
//  ===========
//
//Ticker LCD_RefreshViews;                            // LA:    Non uso un Ticker. Agisce sotto Interrupt e falsa la lettura QEI e la sincronicità del PWM

void    FactoryReset    (void) {
    EepromFactoryReset( );
    HAL_NVIC_SystemReset( );
}

//  =======
//  =======
//  Main(s)
//  =======
//  =======
//
int main    (void){
const float cf_PWMPeriod_s = 0.010;

    rDIR_FWD =  true;   // LA:  Actuator Extends
    rENA_Off =  true;   // LA:  Drive Power is Off

    EepromInit();       // LA:  Inizializza la EEProm
    TimersInit();       // LA:  Parte il Timer a 1ms

    SampleTimer.attach_us(&SampleAndStore, 250);

    // LA:  FactoryReset se "userButton" premuto all'avvio
    //
    if  (userButton == 0) {
        FactoryReset();
    }
    DisplayDriverInit();

    PWM_PB3.period(cf_PWMPeriod_s);     // LA:  Avvia il PWM con TimeBase x [s]
    PWM_PB3.write((float) 0.0);         //      Set to 0%

    // LA:  Motion (1st) Setup
    //
    in_PosizionatoreSW.b_AxisPowered =  true;
    in_PosizionatoreSW.b_ACPos_Homed =  true;
    in_PosizionatoreSW.i32_Max_Speed =  1024;       // [ui]
    in_PosizionatoreSW.i32_ZeroSpeed =  0;          //

    //  POS Mode
    //  ========
    //
    in_PosizionatoreSW.b_ServoLock =    true;
    in_PosizionatoreSW.rtServoLock_Q =  false;
    //
    in_PosizionatoreSW.i64_TargetPosition = 3200;                           // [ui]
    in_PosizionatoreSW.i64_ActualPosition = Stabilus322699.getPulses();     //
    in_PosizionatoreSW.i64_AccelerationWindow = 64;                         // LA:  Spazio concesso all'accelerazione.
    in_PosizionatoreSW.i64_DecelerationWindow = 512;                        //      Spazio concesso alla decelerazione, è prioritario rispetto all'accelerazione.
    in_PosizionatoreSW.i64_diToleranceWindow =  10;                         //      Finestra di Tolleranza
    //
    in_PosizionatoreSW.f_MaximumSpeed_x100_FW = 16.0;                       // % of "i32_Max_Speed"
    in_PosizionatoreSW.f_MaximumSpeed_x100_BW = 60.0;                       //
    in_PosizionatoreSW.f_ServoLockSpeed_x100_FW =   4.8;                    //      Riferimento di velocità minima a cui (appena) si muove l'asse [verso FW]
    in_PosizionatoreSW.f_ServoLockSpeed_x100_BW =   18.0;                   //      Riferimento di velocità minima a cui (appena) si muove l'asse [verso BW]

    //  JOG Mode
    //  ========
    //
    in_PosizionatoreSW.b_JogMode =  false;
    in_PosizionatoreSW.b_JogFW =    false;
    in_PosizionatoreSW.b_JogBW =    false;
    in_PosizionatoreSW.i32_JogAccel_ms =    500;    // [ms]
    in_PosizionatoreSW.i32_JogDecel_ms =    250;    //
    //
    in_PosizionatoreSW.f_JogSpeed_x100_FW = (in_PosizionatoreSW.f_MaximumSpeed_x100_FW/ 2);     // LA:  JOG's the Half of Max POS's Speed
    in_PosizionatoreSW.f_JogSpeed_x100_BW = (in_PosizionatoreSW.f_MaximumSpeed_x100_BW/ 2);     //


    // LA:  Color RGB Component(s)
    //      ======================
    //
    //  RED     0000 1000 0000 0000     min     0x0800  02048
    //          1111 1000 0000 0000     max     0xf800  63488
    //
    //  GREEN   0000 0000 0010 0000     min     0x0020  00032
    //          0000 0111 1110 0000     max     0x07e0  02016
    //
    //  BLUE    0000 0000 0000 0001     min     0x0001  00001
    //          0000 0000 0001 1111     max     0x001f  00031
    //
    //  La componente ROSSA ha  5 bit di escursione (0.. 31),
    //  La componente VERDE ha  6 bit di escursione (0.. 63),
    //  La componente BLU ha    5 bit di escursione (0.. 31),
    //
    //  Le componenti RGB di "Color" sono quindi scritte negli appropriati registri come segue:
    //
    //  writeReg(RED,   (Color & 0xf800) >> 11);
    //  writeReg(GREEN, (Color & 0x07e0) >> 5);
    //  writeReg(BLUE,  (Color & 0x001f));
    //
    LCM_SetTextColor(Scale2RGBColor  (0, 0, 0), Scale2RGBColor  (31, 0, 0));    // LA:  Red on Black
    LCM_ClearScreen (Scale2RGBColor  (0, 0, 0));                                //      Black Background
    LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 0), "You Start Me Up ...");       //      Intro Text

//    rDIR_FWD =  false;      // Collapse
//    rENA_Off =  false;      // Power On

    in_PosizionatoreSW.b_ServoLock =    true;
    in_PosizionatoreSW.rtServoLock_Q =  true;

    while   (1) {
    float   f_PWMPercent;

        in_PosizionatoreSW.i64_ActualPosition = Stabilus322699.getPulses();
        //
        PosizionatoreSW (in_PosizionatoreSW, out_PosizionatoreSW);
        in_PosizionatoreSW.rtServoLock_Q =  false;
    
    //    int64_t   i64_StartPosition;
    //    int64_t   i64_Distance;
    //    bool   b_Accelerating;                   // LA:  bACPos_Accelerating
    //    bool   b_MaxSpeedReached;
    //    bool   b_Decelerating;                   //      bACPos_Decelerating
    //    bool   b_InPosition;
    //    bool   b_InToleranceFW;
    //    bool   b_InToleranceBW;
    
    //    int32_t    i32_ATVSpeed;
        f_PWMPercent =  ((float)out_PosizionatoreSW.i32_ATVSpeed)/ (float)in_PosizionatoreSW.i32_Max_Speed;     // LA:  In Range (float) 0.. 1
        PWM_PB3.write((float) 1.0- f_PWMPercent);                                                               //      Set to x%

    //    bool   b_ATVDirectionFW;
        rDIR_FWD =  out_PosizionatoreSW.b_ATVDirectionFW;
    
    //    bool   b_ATVDirectionBW;
    
    //    bool   b_STW1_On;
    //    bool   b_STW1_NoCStop;
    //    bool   b_STW1_NoQStop;
    //    bool   b_STW1_Enable;
        rENA_Off =  !out_PosizionatoreSW.b_STW1_Enable;

        // LA:  Scope, Theory of operation.
        //      ===========================
        //
        //  1)  Sample a Value @ any Step
        //  2)  Store @ the correct ms
        //  3)  Plot the current Section of the Sampling Vector
        //
        LCM_ShowTactics (
                        Stabilus322699.getPulses(),         // Row  1

                        out_PosizionatoreSW.i32_ATVSpeed,   //      3
                        adc_temp.read(),                    //      4
                        adc_vbat.read(),                    //      5
                        adc_vref.read(),                    //      6

                        ADC12_IN9.read(),                   //      8
                        ADC12_IN15.read(),                  //      9
                        (f_PWMPercent* 100)                 //      10
                        );

        LCM_PlotVector  (
                        Scale2RGBColor  (0, 0, 0),          //  Back:   Black
                        Scale2RGBColor  (31, 0, 0)          //  Fore:   Red
                        );


        if  (out_PosizionatoreSW.b_InPosition)
            if  (in_PosizionatoreSW.i64_TargetPosition > 0)
                in_PosizionatoreSW.i64_TargetPosition = 0;
            else
                in_PosizionatoreSW.i64_TargetPosition = 3200;
    }
}

void    LCM_ShowTactics(
                        int32_t i32_Pulses,
                        int32_t i32_ATVSpeed,
                        float f_ai0000_Aux,
                        float f_ai0001_Aux,
                        float f_ai0002_Aux,
                        float f_ai0003_Aux,
                        float f_ai0004_Aux,
                        float f_ai0005_Aux
                        ) {

char    StringText[MAX_CHAR_PER_LINE+ 1];  // don't forget the /0 (end of string)

static int32_t  Pulses_Prec;
static uint32_t ms_0002_prec;

static float    f_ai0000_prec;
static float    f_ai0001_prec;
static float    f_ai0002_prec;
static float    f_ai0003_prec;
static float    f_ai0004_prec;
static float    f_ai0005_prec;

    if  (i32_Pulses !=  Pulses_Prec) {
        sprintf (StringText,
                "Pulses: %d     ", i32_Pulses);
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 1), StringText);
        Pulses_Prec =   i32_Pulses;
    }

    if  (i32_ATVSpeed != ms_0002_prec) {
        sprintf (StringText,
                "Speed[ui]: %d     ", i32_ATVSpeed);
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 3), StringText);
        ms_0002_prec = i32_ATVSpeed;
    }

    if  (f_ai0000_Aux != f_ai0000_prec) {
        sprintf (StringText,
                "ADC Temp = %f ", (f_ai0000_Aux* 100));
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 4), StringText);
        f_ai0000_prec = f_ai0000_Aux;
    }

    if  (f_ai0001_Aux != f_ai0001_prec) {
        sprintf (StringText,
                "ADC VBat = %f ", (f_ai0001_Aux* 10));
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 5), StringText);
        f_ai0001_prec = f_ai0001_Aux;
    }

    if  (f_ai0002_Aux != f_ai0002_prec) {
        sprintf (StringText,
                "ADC VRef = %f ", (f_ai0002_Aux* 10));
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 6), StringText);
        f_ai0002_prec = f_ai0002_Aux;
    }

    if  (f_ai0003_Aux != f_ai0003_prec) {
        sprintf (StringText,
                "ADC12.09 = %f ", (f_ai0003_Aux* 10)/ 3);
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 8), StringText);
        f_ai0003_prec = f_ai0003_Aux;
    }

    if  (f_ai0004_Aux != f_ai0004_prec) {
        sprintf (StringText,
                "ADC12.15 = %f ", (f_ai0004_Aux* 10)/ 3);
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 9), StringText);
        f_ai0004_prec = f_ai0004_Aux;
    }

    if  (f_ai0005_Aux != f_ai0005_prec) {
        sprintf (StringText,
                "PB3 PWM%% = %f ", (f_ai0005_Aux));
        LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 10), StringText);
        f_ai0005_prec = f_ai0005_Aux;
    }
}

//static void SampleAndStore  (void) {
void    SampleAndStore  (void) {
//static int32_t i32_Pulses;
int16_t i16_SampleIndex;
//float   f_SampleAux;

//    af_PlotSamples[240- 1] =   ADC12_IN9.read();
    af_PlotSamples[240- 1] =   (float)  Stabilus322699.getChannelA() * 0.33f;

    for (i16_SampleIndex = 0; i16_SampleIndex < (240- 1); i16_SampleIndex++)
        af_PlotSamples[i16_SampleIndex] =   af_PlotSamples[i16_SampleIndex+ 1];

//    i32_Pulses++;
}

//        getDmTft().setPixel    (0,0,1);
