

//Warning: Incompatible redefinition of macro "MBED_RAM_SIZE"  in "tmp/HU5Hqj", Line: 39, Col: 10
#ifndef MBED_RAM_SIZE
#define MBED_RAM_SIZE 0x00018000
#endif

#include "QEI.h"
#include "SWPos.h"

#include "Timers.h"
//#include "Menu.h"
#include "Eeprom.h"
//#include "main.h"
//#include "app_config.h"

#define MAX_CHAR_PER_LINE   28
#define TEXT_ROW_SPACING    16
#define FONT_CHAR_WIDTH 8
#define FONT_CHAR_HEIGHT    16

//#include "mbed.h"
#include "DisplayDriver.h"
//#include "DmTftIli9341.h"
//#include "DmTouch.h"
//#include "DmTouchCalibration.h"

// LA:  Theory of Operation
//      ===================
//
//  Il PWM funziona da sè in Interrupt
//  Il QEI funziona da sè in Interrupt
//  Se si creano dei Ticker (Che sono a loro volta interrupt(s)) è possibile che PWM e QEI perdano correlazione con l'HW.
//
//  PQM
//
//  Il rinfresco del Display e la gestione del motion vanno fatte il più frequentemente possibile ma fuori dal loop dei Ticker.
//  Con qst versione (LA0005, che termina un FORK (il successivo è LA0010) quanto detto sopra è FUNZIONANTE.
//  Questo messaggio è incluso nel "commitment"

/*!
 * \brief Define IO for Unused Pin
 */
//DigitalOut  F_CS    (D6);               // MBED description of pin
//DigitalOut  SD_CS   (D8);               // MBED description of pin

DigitalIn   userButton  (USER_BUTTON);

AnalogIn    adc_temp    (ADC_TEMP);
AnalogIn    adc_vref    (ADC_VREF);
AnalogIn    adc_vbat    (ADC_VBAT);

//  PWM
//  ===
//
PwmOut PWM_PB3(PWM_OUT);       // LA:  PWM_OUT = D3 = PB_3

//  QEI
//  ===
//
QEI Stabilus322699  (PA_1, PA_0, NC, 100, QEI::X4_ENCODING);

//  Motion
//  ======
//
//Ticker POS_MotionScan;                              // LA:    Non uso un Ticker. Agisce sotto Interrupt e falsa la lettura QEI e la sincronicità del PWM
//
in_sPosizionatoreSW    in_PosizionatoreSW;
out_sPosizionatoreSW   out_PosizionatoreSW;

//  LCD Display
//  ===========
//
//Ticker LCD_RefreshViews;                            // LA:    Non uso un Ticker. Agisce sotto Interrupt e falsa la lettura QEI e la sincronicità del PWM

void    FactoryReset    (void) {
    EepromFactoryReset( );
    HAL_NVIC_SystemReset( );
}

//  =======
//  =======
//  Main(s)
//  =======
//  =======
//
int main    (void){
char StringText[MAX_CHAR_PER_LINE + 1];  // don't forget the /0 (end of string)
//char StringText2[MAX_CHAR_PER_LINE + 1];
//char StringText3[MAX_CHAR_PER_LINE + 1];

//uint16_t    ui16_TestColor = 0x0000;
//uint16_t    ui16_TestStep = 0x0000;
//
//uint16_t    ui16_R = 0x00;
//uint16_t    ui16_G = 0x00;
//uint16_t    ui16_B = 0x00;

uint32_t ui32_PreCallms;
uint32_t ui32_PostCallms;
uint32_t ui32_Samplems;


    EepromInit();       // LA:  Inizializza la EEProm
    TimersInit();       // LA:  Parte il Timer a 1ms

    // LA:  FactoryReset se "userButton" premuto all'avvio
    //
    if  (userButton == 0) {
        FactoryReset();
    }
    DisplayDriverInit();

    PWM_PB3.period_us(100);         // LA:  Avvia il PWM con TimeBase 100us
    PWM_PB3.pulsewidth_us(0);       //      0.. 100us ->   0.. 100%,    Set to ZERO

    // LA:  Motion (1st) Setup
    //
    in_PosizionatoreSW.b_AxisPowered =  true;
    in_PosizionatoreSW.b_ACPos_Homed =  true;
    in_PosizionatoreSW.i32_Max_Speed =  1024;       // [ui]
    in_PosizionatoreSW.i32_ZeroSpeed =  0;          //

    in_PosizionatoreSW.b_JogMode =  false;
    in_PosizionatoreSW.b_JogFW =    false;
    in_PosizionatoreSW.b_JogBW =    false;
    in_PosizionatoreSW.i32_JogAccel_ms =    500;    // [ms]
    in_PosizionatoreSW.i32_JogDecel_ms =    250;    //
    //
    in_PosizionatoreSW.f_JogSpeed_x100_FW = 25.0;   // % of "i32_Max_Speed"
    in_PosizionatoreSW.f_JogSpeed_x100_BW = 25.0;   //

    in_PosizionatoreSW.b_ServoLock =    true;
    in_PosizionatoreSW.rtServoLock_Q =  false;
    //
    in_PosizionatoreSW.i64_TargetPosition = 1000;      // [ui]
    in_PosizionatoreSW.i64_ActualPosition = 200;      //
    in_PosizionatoreSW.i64_AccelerationWindow = 50;  // LA:  Spazio concesso all'accelerazione.
    in_PosizionatoreSW.i64_DecelerationWindow = 50;  //      Spazio concesso alla decelerazione, è prioritario rispetto all'accelerazione.
    in_PosizionatoreSW.i64_diToleranceWindow =  10;  //      Finestra di Tolleranza
    //
    in_PosizionatoreSW.f_MaximumSpeed_x100_FW = 25.0;       // % of "i32_Max_Speed"
    in_PosizionatoreSW.f_MaximumSpeed_x100_BW = 25.0;       //
    in_PosizionatoreSW.f_ServoLockSpeed_x100_FW =   5.0;    //
    in_PosizionatoreSW.f_ServoLockSpeed_x100_BW =   5.0;    //

    // LA:  Color RGB Component(s)
    //      ======================
    //
    //  RED     0000 1000 0000 0000     min     0x0800  02048
    //          1111 1000 0000 0000     max     0xf800  63488
    //
    //  GREEN   0000 0000 0010 0000     min     0x0020  00032
    //          0000 0111 1110 0000     max     0x07e0  02016
    //
    //  BLUE    0000 0000 0000 0001     min     0x0001  00001
    //          0000 0000 0001 1111     max     0x001f  00031
    //
    //  La componente ROSSA ha  5 bit di escursione (0.. 31),
    //  La componente VERDE ha  6 bit di escursione (0.. 63),
    //  La componente BLU ha    5 bit di escursione (0.. 31),
    //
    //  Le componenti RGB di "Color" sono quindi scritte negli appropriati registri come segue:
    //
    //  writeReg(RED,   (Color & 0xf800) >> 11);
    //  writeReg(GREEN, (Color & 0x07e0) >> 5);
    //  writeReg(BLUE,  (Color & 0x001f));
    //
    LCM_SetTextColor(Scale2RGBColor  (31, 31, 31), Scale2RGBColor  (0, 0, 0));  // LA:  Black on White
    LCM_ClearScreen (Scale2RGBColor  (31, 31, 31));

//    ui16_TestColor =    Scale2RGBColor  (ui16_R, ui16_G, ui16_B);
//    LCM_SetTextColor    (
//                        Scale2RGBColor  (0, 0, 0),
//                        Scale2RGBColor  (31, 31, 31)
//                        );
    LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 0), "You Start Me Up ...");

    while   (1) {
    static int32_t  Pulses_Prec;
    static uint32_t ms_0002_prec;
    static uint32_t ms_0003_prec;
    int32_t i32_Pulses;

    float   f_ai0000_Aux;
    float   f_ai0000_prec;
    float   f_ai0001_prec;
    float   f_ai0002_prec;

        i32_Pulses =    Stabilus322699.getPulses();
        PWM_PB3.pulsewidth_us(((float)i32_Pulses/ (float)5000.0)* (float)100.0);      //      0.. 100us ->   0.. 100%

        in_PosizionatoreSW.i64_ActualPosition = (int64_t) i32_Pulses;      //

        ui32_PreCallms =    TimersTimerValue();                                     //  Freezes the Actual Sample.
        PosizionatoreSW (in_PosizionatoreSW, out_PosizionatoreSW);
        ui32_PostCallms =   TimersTimerValue();
        //
        if  (ui32_PostCallms >= ui32_PreCallms)
            ui32_Samplems = ui32_PostCallms- ui32_PreCallms;                        //  Result =>   Actual - Previous
        else
            ui32_Samplems =  ui32_PostCallms+ (0x7fffffff- ui32_PreCallms);         //  Result =>   Actual+ (Rollover- Previous)
        

        // LA:  Wedge 4 LCDRefresh
        if  (
                (i32_Pulses !=  Pulses_Prec)
            ) {
            sprintf (StringText,
                    "Pulses: %d     ", i32_Pulses);
            LCM_SetTextColor    (Scale2RGBColor  (0, 0, 31), Scale2RGBColor  (31, 31, 0));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 1), StringText);
        }

//        if  (out_PosizionatoreSW.ui32_PassedActual_ms != ms_0003_prec) {
        if  (ui32_Samplems != ms_0003_prec) {
            sprintf (StringText,
//                    "PassedActual_ms: %d     ", out_PosizionatoreSW.ui32_PassedActual_ms);
                    "PassedActual_ms: %d     ", ui32_Samplems);
            LCM_SetTextColor    (Scale2RGBColor  (0, 31, 0), Scale2RGBColor  (31, 0, 31));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 2), StringText);
//            ms_0003_prec = out_PosizionatoreSW.ui32_PassedActual_ms;
            ms_0003_prec = ui32_Samplems;
        }

        if  (out_PosizionatoreSW.i32_ATVSpeed != ms_0002_prec) {
            sprintf (StringText,
                    "Speed[ui]: %d     ", out_PosizionatoreSW.i32_ATVSpeed);
            LCM_SetTextColor    (Scale2RGBColor  (0, 31, 0), Scale2RGBColor  (31, 0, 31));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 3), StringText);
            ms_0002_prec = out_PosizionatoreSW.i32_ATVSpeed;
        }

        f_ai0000_Aux =  adc_temp.read();
        if  (f_ai0000_Aux != f_ai0000_prec) {
            sprintf (StringText,
//                    "ADC Temp = %f\n", (f_ai0000_Aux* 100));
                    "ADC Temp = %f ", (f_ai0000_Aux* 100));
            LCM_SetTextColor    (Scale2RGBColor  (0, 31, 0), Scale2RGBColor  (31, 0, 31));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 4), StringText);
            f_ai0000_prec = f_ai0000_Aux;
        }

        f_ai0000_Aux =  adc_vbat.read();
        if  (f_ai0000_Aux != f_ai0001_prec) {
            sprintf (StringText,
//                    "ADC VBat = %f\n", (f_ai0000_Aux* 100));
                    "ADC VBat = %f ", (f_ai0000_Aux));
            LCM_SetTextColor    (Scale2RGBColor  (0, 31, 0), Scale2RGBColor  (31, 0, 31));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 5), StringText);
            f_ai0001_prec = f_ai0000_Aux;
        }

        f_ai0000_Aux =  adc_vref.read();
        if  (f_ai0000_Aux != f_ai0002_prec) {
            sprintf (StringText,
//                    "ADC VRef = %f\n", (f_ai0000_Aux* 100));
                    "ADC VRef = %f ", (f_ai0000_Aux));
            LCM_SetTextColor    (Scale2RGBColor  (0, 31, 0), Scale2RGBColor  (31, 0, 31));
            LCM_DrawString  (0, 0+ (TEXT_ROW_SPACING* 6), StringText);
            f_ai0002_prec = f_ai0000_Aux;
        }
    }
}

/*
    while   (ui16_TestStep < 32) {

        ui16_TestColor =    Scale2RGBColor  (ui16_R, ui16_G, ui16_B);
        LCM_ClearScreen (ui16_TestColor);
        LCM_SetTextColor(ui16_TestColor, (0xffff- ui16_TestColor));
        sprintf (StringText,
                "Color: %04x %04x ", ui16_TestColor, ui16_TestStep);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 4), StringText);
        sprintf (StringText,
                "R:%02x G:%02x B:%02x ", ui16_R, ui16_G, ui16_B);
        LCM_DrawString  (0, 0+(TEXT_ROW_SPACING* 5), StringText);
//        delay (500);

        ui16_R++;
        ui16_G++;
        ui16_B++;
//        ui16_TestColor +=   0x0841;
        ui16_TestStep ++;
    }
    delay (2500);
*/