//=================================================================
// The file is for module "compost pile"
//
// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================

#include "compost_pile_private.h"
#include "graphics.h"
COMPOST compost_record[NUM_PILE];
int TPH;
COMPOST tallestPile;

// See the comments in compost_pile_public.h
void compost_pile_init() {
    TPH = 0;
    
    for(int i =0;i<NUM_PILE;i++){  
        compost_record[i].x = (i*11);
        compost_record[i].height = 0;
        }
}
COMPOST compost_get_info(int index){
   COMPOST compIn = compost_record[index];
   return compIn;
}

void compost_add(int index) {
    compost_record[index].height = compost_record[index].height+ PILE_WIDTH;
    compost_record[index].space = index;
    set_compost_size(index);
    if(compost_record[index].height > (TPH*11)){
        TPH++;
        tallestPile = compost_record[index];
    }
}
void removeTop(void){
    if(TPH > 0){
        boundingBox holderBox;
        
        COMPOST compIn = compost_record[tallestPile.space];

        holderBox.topLeft.x = compIn.x;
        holderBox.topLeft.y = 120 - compIn.height;
        holderBox.bottomRight.x = compIn.x + PILE_WIDTH;
        holderBox.bottomRight.y = 120 - compIn.height+11;

        draw_nothing(holderBox);
        
        compost_record[tallestPile.space].height = compIn.height - PILE_WIDTH;
        
        set_compost_size(tallestPile.space);
        TPH--;
        
        for(int i =0;i<NUM_PILE;i++){        
            if(compost_record[i].height >= (TPH*11)){
                if(compost_record[i].height > (TPH*11)) TPH++; 
                tallestPile = compost_record[i];
            }
        }
        
    }
}
COMPOST getTallestComp(void){
    return tallestPile;
}
int get_compost_tallest_height(void) {
    return TPH;
}

void set_compost_size(int index) {
    COMPOST compIn = compost_record[index];

    compost_record[index].comBox.topLeft.x = compIn.x;
    compost_record[index].comBox.topLeft.y = 120 - compIn.height;
    compost_record[index].comBox.bottomRight.x = compIn.x + PILE_WIDTH;
    compost_record[index].comBox.bottomRight.y = 120;
    draw_comp(compost_record[index].comBox);
}
void maintainComp(void){
 for(int i = 0;i<NUM_PILE;i++){
     draw_comp(compost_record[i].comBox);
     }   
}
boundingBox get_compost_size(int index){
    COMPOST compIn = compost_record[index];
    return compIn.comBox;
}