//=================================================================
// Implementation for the player module
//
// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================
#include "player_private.h"

extern DigitalOut myled1(LED1);
extern DigitalOut myled2(LED2);
extern DigitalOut myled3(LED3);
extern DigitalOut myled4(LED4);
PLAYER player; // structure of player
/*
    int id;
    int kPos;
    bool PHK    // The knife status: 0->In the air 1->With Player
    boundingBox knife_boundingBox;
    int active;
}KNIFE;

    int score;                  // Current score         
    int lives;
    int y;
    KNIFE knife[2];
} PLAYER;
*/

PLAYER player_get_info(void){
    return player;
}
int returnMiss(void){
  return player.misses;   
}
int returnCK(void){

  if(player.knife[0].PHK == 1)
  { 
  return player.knife[0].id;
  }
  else if (player.knife[1].PHK == 1)
  {  
  
  return player.knife[1].id;
  }   
  return 0;
}
int getLives(void){
    return player.lives;   
}
bool dead(int n){
    if((n == 0)&&((player.misses == 7)||(player.lives == 0))) return true;
    else return false;
}
void miss(void){
    player.misses++;
}
void hurt(void){
    player.combo = 1;
    player.lives--;
    if(player.lives == 2) myled3 = 0;
    if (player.lives == 1) myled2 = 0;
    if(player.lives ==0) myled1= 0;
}

void player_init(void) { 
    player.combo = 1;
    player.misses = 0;
    player.y = 0;
    player.score = 0;
    player.lives = 3;
    
    myled1 =1;
    myled2 = 1;
    myled3 = 1;

    draw_player(0,player.y,0xFFFFFF);
    
    knifeInit(0);
    player.knife[1].PHK = 2;
}

void knifeInit(int n){
    player.knife[n].id = n+1;
    player.knife[n].kPos = 11;
    player.knife[n].kbb.topLeft.x = 11;
    player.knife[n].kbb.topLeft.y = player.y + 4;
    player.knife[n].kbb.bottomRight.x = 11 + KNIFE_LENGTH;
    player.knife[n].kbb.bottomRight.y = player.y;
    player.knife[n].PHK = 1;
    draw_knife(player.knife[n].kbb);

}

void player_moveUp(void) { 
    draw_player(0,player.y,0x000000);
    if(returnCK() != 0) draw_nothing(player.knife[returnCK()-1].kbb);
    
    COMPOST compIn = getTallestComp();
    if(player.y < (110 - compIn.height)){//what is the max height
        player.y = player.y + 10;
        if(returnCK() != 0){
            player.knife[returnCK()-1].kbb.topLeft.y = player.y + 4;
            player.knife[returnCK()-1].kbb.bottomRight.y = player.y;   
        }
    }
    draw_player(0,player.y,0xFFFFFF);
    if(returnCK() != 0) draw_knife(player.knife[returnCK()-1].kbb);
}
void player_moveDown(void) { 
    draw_player(0,player.y,0x000000);
    if(returnCK() != 0) draw_nothing(player.knife[returnCK()-1].kbb);

    if(player.y > 0){
        player.y = player.y - 10;
        
        if(returnCK() != 0){
            player.knife[returnCK()-1].kbb.topLeft.y = player.y + 4;
            player.knife[returnCK()-1].kbb.bottomRight.y = player.y;   
        }
    }
    draw_player(0,player.y,0xFFFFFF);
    if(returnCK() != 0) draw_knife(player.knife[returnCK()-1].kbb);
}

void doReturnK(int n, int m){
            draw_nothing(player.knife[n].kbb);
            player.knife[n].PHK = 2;
            player.knife[n].kPos = 0;
            if(m == 1){
                miss();
                player.combo = 1;
            }
            if((player.knife[0].PHK == 2)&&(player.knife[1].PHK == 2)) knifeInit(0);
            pc.printf("THHHHHHHHHHHHHHHHHHHISHSIHSIHSIHSIH %d\n\n\n",player.combo);
}
void player_throw(void) { 

    if(returnCK() != 0){//checkning which knife should be thrown 

         player.knife[returnCK()-1].PHK = 0;
    }
}
void player_knife_draw(void) {    
    if(player.knife[0].PHK == 0 && player.knife[0].kPos+6 < 120){//what is the max height
        draw_nothing(player.knife[0].kbb);
        
        player.knife[0].kPos = player.knife[0].kPos + 5 ;
        player.knife[0].kbb.topLeft.x = player.knife[0].kPos;
        player.knife[0].kbb.bottomRight.x = player.knife[0].kPos + KNIFE_LENGTH;
        
        draw_knife(player.knife[0].kbb);
    }
    else if(player.knife[0].kPos+6 >= 120){
           doReturnK(0,1);
    }
    if((player.knife[1].PHK == 2)&&(player.knife[0].kPos+6 >= 60)){
        knifeInit(1);
        
        
    }
    if(player.knife[1].PHK == 0 && player.knife[1].kPos+6 < 120){//what is the max height

        draw_nothing(player.knife[1].kbb);
        
        player.knife[1].kPos = player.knife[1].kPos + 5 ;
        player.knife[1].kbb.topLeft.x = player.knife[1].kPos;
        player.knife[1].kbb.bottomRight.x = player.knife[1].kPos + KNIFE_LENGTH;
        
        draw_knife(player.knife[1].kbb);
    }
    else if(player.knife[1].kPos+6 >= 120){
        doReturnK(1,1);
    }
   if((player.knife[0].PHK == 2)&&(player.knife[1].kPos+6 >= 60)){

        knifeInit(0);
        
    }
}


KNIFE getKnifeInfo(int n){
    return player.knife[n];
}

// ==== player_private.h implementation ====

void player_score_inc(int n) {
    
    pc.printf("THHHHHHHHHHHHfffffffffffffffffffffIHSIHSIH %d\n\n\n",player.combo);
    player.score = player.score + player.combo;
    if(n == 1) player.combo++;
}
