#include "graphics.h"
#include "globals.h"

#define YELLOW 0xFFFF00
#define GREEN 0x00FF00
#define WHITE 0xFFFFFF
#define BLACK 0x000000
#define BROWN  0xD2691E
#define DIRT   BROWN
#define RED    0xFF0000
#define ORANGE 0xFFA500
#define GRAY 0xA0A0A0
void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = YELLOW;
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = DIRT;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_player(int u, int v, int key)
{
    uLCD.filled_rectangle(u, v+2, u+11, v+4, WHITE);
    uLCD.filled_rectangle(u, v+4, u+11, v+11, BLUE);
    uLCD.filled_rectangle(u, v+7, u+3, v+9, BLACK);
    uLCD.filled_rectangle(u+8, v+7, u+11, v+9, BLACK);
    if(key == 0x000000) uLCD.filled_rectangle(u, v, u+11, v+11, key);

}

void draw_scoreBoard(int score){
    uLCD.locate(0, 15);
    uLCD.color(WHITE);
    uLCD.printf("S:%d ",score);
}
void draw_scoreMisses(int misses){
    uLCD.locate(5, 15);
    uLCD.color(WHITE);
    uLCD.printf("M:%d ",misses);
}
void draw_scoreCombo(int combo){
    uLCD.locate(10, 15);
    uLCD.color(WHITE);
    uLCD.printf("C:%d ",combo);
}
void drawPause(void){
    uLCD.locate(3, 15);
    uLCD.color(WHITE);
    uLCD.printf("GAME PAUSED");
}

void draw_ground(){
    uLCD.filled_rectangle(0, 120, 120, 125, GREEN);
    uLCD.filled_rectangle(0,125,120,135,DIRT);
}

void draw_nothing(boundingBox b)
{
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, BLACK);
}
void draw_nothing2(boundingBox b)
{
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, GRAY);
}
void draw_nothingOrange(boundingBox b)
{
    // Erase a bounding box
    uLCD.filled_circle(b.topLeft.x,b.bottomRight.y, 6, BLACK);  
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y+2, b.topLeft.x+3, b.topLeft.y+4, BLACK);    
    }
void drawPractice(boundingBox b){
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 6, RED);  
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 4, WHITE);  
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 2, RED);  
}

void draw_bomb(boundingBox b)
{

    // Draw an apple using a filled_rectangle or get creative and use a sprite!
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 6, GRAY);  
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 2, RED);  
    uLCD.filled_rectangle(b.topLeft.x-1, b.topLeft.y-8, b.topLeft.x+1, b.topLeft.y-6, BROWN);
    uLCD.filled_rectangle(b.topLeft.x-1, b.topLeft.y-9, b.topLeft.x+1, b.topLeft.y-8, RED);


}
void draw_nothingBomb(boundingBox b){
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 6, BLACK);  
    uLCD.filled_rectangle(b.topLeft.x-1, b.topLeft.y-8, b.topLeft.x+1, b.topLeft.y-6, BLACK);
    uLCD.filled_rectangle(b.topLeft.x-1, b.topLeft.y-9, b.topLeft.x+1, b.topLeft.y-8, BLACK);

}
void draw_Rec(boundingBox b){  
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 6, GRAY);  
    uLCD.filled_circle(b.topLeft.x,b.topLeft.y, 2, GREEN);  
    uLCD.filled_rectangle(b.topLeft.x-1, b.topLeft.y-8, b.topLeft.x+1, b.topLeft.y-6, BROWN);
    uLCD.filled_rectangle(b.topLeft.x-1, b.topLeft.y-9, b.topLeft.x+1, b.topLeft.y-8, RED);
}


void draw_banana(boundingBox b)
{
    // Draw a banana using a filled_rectangle or get creative and use a sprite!
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, YELLOW);
}
void draw_realOrange(boundingBox b)
{
    // Draw a banana using a filled_rectangle or get creative and use a sprite!
   uLCD.filled_circle(b.topLeft.x,b.bottomRight.y, 6, ORANGE);  
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y+2, b.topLeft.x+3, b.topLeft.y+4, GREEN);
}
void drawBigOrange(boundingBox b){
     uLCD.filled_circle(b.topLeft.x,b.bottomRight.y, 9, ORANGE);  
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.topLeft.x+4, b.topLeft.y+3, GREEN);
  
}
void nothingBigOrange(boundingBox b){
     uLCD.filled_circle(b.topLeft.x,b.bottomRight.y, 9, BLACK);  
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.topLeft.x+4, b.topLeft.y+3, BLACK);
  
}
void drawRealBanana(boundingBox b){
    uLCD.filled_circle(b.topLeft.x+5,b.topLeft.y+6, 4, YELLOW);  
    uLCD.filled_circle(b.topLeft.x+9,b.topLeft.y+6, 3, BLACK);  
    uLCD.filled_rectangle(b.topLeft.x+4, b.topLeft.y, b.topLeft.x+8, b.topLeft.y+1, GREEN);
}

void draw_knife(boundingBox b){
    uLCD.filled_rectangle(b.topLeft.x+2, b.bottomRight.y, b.topLeft.x+6, b.bottomRight.y+2, GRAY);
    uLCD.filled_rectangle(b.topLeft.x+2, b.bottomRight.y+2, b.topLeft.x+4, b.bottomRight.y+3, GRAY);
    uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y-1, b.topLeft.x+2, b.bottomRight.y, BROWN);
}
void draw_comp(boundingBox b){
        uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, GREEN);
}
