//=================================================================
// The main program file.
//
// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================

// External libs
#include <stdlib.h>

// Project includes
#include "globals.h"
#include "hardware.h"
#include "compost_pile_public.h"
#include "fruit_public.h"
#include "player_public.h"
//SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sck, cs


// ===User implementations start===
int fruit_contact(void); // iterate through fruits and see if any collided
void compost_pile_update(void);
void set_random_seed(Timer);
int gameOver(int);
void pause(PLAYER ply);
bool paused = false;
int end = 0;
int pMode = 0;

int main()
{
    GameInputs inputs; 
    // First things first: initialize hardware
    ASSERT_P(hardware_init() == ERROR_NONE, "Hardware init failed!");
    pc.printf("Program Starting\n");
    
    // ===User implementations start===
    // Game state variables
    /*
    struct GameInputs {
    int b1, b2, b3;     // Button presses
    double ax, ay, az;  // Accelerometer readings
};
*/
    // Timer to measure game update speed (secondarily used to generate random seed)
    Timer t;
    int dt; // delta time
    set_random_seed(t);
    

    //initialize functions
    compost_pile_init();
    fruit_init();
    player_init();     
    
    PLAYER ply = player_get_info();
   
    pc.printf("Initialization complete\n");

    draw_scoreBoard(ply.score);
    draw_scoreCombo(ply.combo);
    draw_scoreMisses(ply.misses);
    int getMiss = returnMiss();
    while(1)
    {

        t.start();
        ply = player_get_info();
        // Draw fruits first
        //pc.printf("fruit_generator\n");
        fruit_generator();
        //Put score on screen
        // NOTE: Text is 8 pixels tall

        pc.printf("player_fruit_draw\n");
        
        
        
        //pc.printf("Reading inputs\n");
        inputs = read_inputs();
        

        //pc.printf("player motions\n");
        if (!inputs.b1 || inputs.ay >=0.4) player_moveUp();            
        else if (!inputs.b2 || inputs.ay <= -0.4)
        { 
            player_moveDown();                
        }
        else if (!inputs.b3)
        {
             player_throw();
        }
        else if((!paused)&&(!inputs.b4))
        {
            pause(ply);   
        }
        while(paused){
            inputs = read_inputs();
            if(!inputs.b1){

                pause(ply);   
            }
        }
        if(ply.misses != getMiss){
            ply = player_get_info();    
            draw_scoreMisses(ply.misses);
            draw_scoreCombo(ply.combo);
            getMiss = ply.misses;
    }
        
        player_knife_draw();
        //pc.printf("compost_pile_update\n");
        
        //pc.printf("fruit_contact\n");
        int is_bomb = fruit_contact();
        
        // TODO: Check end of the game        
        //pc.printf("check endgame\n");
        
        // TODO: Check if game won
        // Compute update time
        t.stop();
        dt = t.read_ms();
        
        if (dt < 100) wait_ms(100 - dt);
        if(gameOver(3)) break;
        
    }
    pc.printf("out of main loop\n");
    destroyList(get_fruit_list());

    return 0;
    // ===User implementations end===
}

// ===User implementations start===

/* This function iterate through the fruit list, checking if anyone one of them is contacting 
*  with the player's knife. Don't forget to check if the "fruit" is the bomb, since we 
*  generated bombs using the fruit_generator. 
*/ 
void pause(PLAYER ply){
    if(paused){
        paused = false;
        draw_ground();
        draw_scoreBoard(ply.score);
        draw_scoreCombo(ply.combo);
        draw_scoreMisses(ply.misses);
    }
    else{
     paused = true;
        draw_ground();
        drawPause();
        
    }
    
}
int fruit_contact(void) {
    PLAYER ply = player_get_info();

    /*     newFruit->box.topLeft.x 
            newFruit->box.topLeft.y 
            newFruit->box.bottomRight.x 
            newFruit->box.bottomRight.y
            
            player.knife_boundingBox.topLeft.x;
            player.knife_boundingBox.bottomRight.x ;

            player.knife_boundingBox.topLeft.y;
            player.knife_boundingBox.bottomRight.y ;
        */
    DLinkedList* fruitDLL = get_fruit_list();
    LLNode* current = fruitDLL->head;
    FRUIT* newFruit;
    //iterate over all fruits
    while(current)
    {   
        newFruit = (FRUIT*) current->data;
        
        KNIFE knife1 = getKnifeInfo(0);
        KNIFE knife2 = getKnifeInfo(1);
        boundingBox knifePos1 = knife1.kbb;
        boundingBox knifePos2 = knife2.kbb;

    //need to check if each corner is inside the fruit
    
    /*pc.printf("\n\n\n\n\n\n\n\n %p     %p\n topleft x %d   %d\ntopleft y %d    %d\n bottem right x %d     %d\nbottem right y %d     %d\n\n\n\n\n\n\n",current,current->next,
    newFruit->box.topLeft.x ,knifePos.topLeft.x,
    newFruit->box.bottomRight.y ,knifePos.topLeft.y,   
    newFruit->box.bottomRight.x, knifePos.bottomRight.x,
    newFruit->box.topLeft.y, knifePos.bottomRight.y );*/
    //if(ply.player_has_knife == 0){

        if((newFruit->box.topLeft.x <= knifePos1.topLeft.x) && (newFruit->box.bottomRight.x >= knifePos1.topLeft.x) && (newFruit->box.bottomRight.y >= knifePos1.topLeft.y) && (newFruit->box.topLeft.y <= knifePos1.topLeft.y)){
                newFruit->status = FRUIT_SLICED;
                if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    player_score_inc(1);
                    ply = player_get_info();    
                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                    }
                doReturnK(0,0);
            }
        else if((newFruit->box.topLeft.x <= knifePos1.bottomRight.x) && (newFruit->box.bottomRight.x >= knifePos1.bottomRight.x) && (newFruit->box.bottomRight.y >= knifePos1.bottomRight.y) && (newFruit->box.topLeft.y <= knifePos1.bottomRight.y)){
                newFruit->status = FRUIT_SLICED;
               if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    
                    player_score_inc(1);
                                        ply = player_get_info();    

                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                    }
                doReturnK(0,0);
            }
        else if((newFruit->box.topLeft.x <= knifePos1.topLeft.x) && (newFruit->box.bottomRight.x >= knifePos1.topLeft.x) && (newFruit->box.bottomRight.y >= knifePos1.bottomRight.y) && (newFruit->box.topLeft.y <= knifePos1.bottomRight.y)){
                newFruit->status = FRUIT_SLICED;
                if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    player_score_inc(1);
                                        ply = player_get_info();    

                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                }
                doReturnK(0,0);
            }
        else if((newFruit->box.topLeft.x <= knifePos1.bottomRight.x) && (newFruit->box.bottomRight.x >= knifePos1.bottomRight.x) && (newFruit->box.bottomRight.y >= knifePos1.topLeft.y) && (newFruit->box.topLeft.y <= knifePos1.topLeft.y)){
                newFruit->status = FRUIT_SLICED;
                if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    player_score_inc(1);
                                        ply = player_get_info();    

                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                    }
                doReturnK(0,0);
    }
            
        if((newFruit->box.topLeft.x <= knifePos2.topLeft.x) && (newFruit->box.bottomRight.x >= knifePos2.topLeft.x) && (newFruit->box.bottomRight.y >= knifePos2.topLeft.y) && (newFruit->box.topLeft.y <= knifePos2.topLeft.y)){
                newFruit->status = FRUIT_SLICED;
                if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    player_score_inc(1);
                                        ply = player_get_info();    

                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                }
                doReturnK(1,0);
            }
        else if((newFruit->box.topLeft.x <= knifePos2.bottomRight.x) && (newFruit->box.bottomRight.x >= knifePos2.bottomRight.x) && (newFruit->box.bottomRight.y >= knifePos2.bottomRight.y) && (newFruit->box.topLeft.y <= knifePos2.bottomRight.y)){
                newFruit->status = FRUIT_SLICED;
               if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    player_score_inc(1);
                                        ply = player_get_info();    

                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                    }
                doReturnK(1,0);
            }
        else if((newFruit->box.topLeft.x <= knifePos2.topLeft.x) && (newFruit->box.bottomRight.x >= knifePos2.topLeft.x) && (newFruit->box.bottomRight.y >= knifePos2.bottomRight.y) && (newFruit->box.topLeft.y <= knifePos2.bottomRight.y)){
                newFruit->status = FRUIT_SLICED;
                if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    player_score_inc(1);
                                        ply = player_get_info();    

                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                    }
                doReturnK(1,0);
            }
        else if((newFruit->box.topLeft.x <= knifePos2.bottomRight.x) && (newFruit->box.bottomRight.x >= knifePos2.bottomRight.x) && (newFruit->box.bottomRight.y >= knifePos2.topLeft.y) && (newFruit->box.topLeft.y <= knifePos2.topLeft.y)){
                newFruit->status = FRUIT_SLICED;
                if(newFruit->type == 0){
                    hurt();
                }
                else if(newFruit->type ==3){
                    removeTop();   
                }
                else if(newFruit->type ==4){
                    player_score_inc(0);

                }
                else{
                    player_score_inc(1);
                    draw_scoreBoard(ply.score);
                    draw_scoreCombo(ply.combo);
                    }
                doReturnK(1,0);
            }    
        if(dead(pMode)){
             gameOver(0);
             }

        int index = (((newFruit->box.topLeft.x+5)/11)%11);
        COMPOST compIn = compost_get_info(index);
        if(newFruit->box.bottomRight.y >= (115 - compIn.height)){
            newFruit-> status = FRUIT_SLICED;
            if((newFruit->type != 0)&&(newFruit->type != 3)&&(newFruit->type != 5)) {
                compost_add(index);
                if(newFruit->type == 4) compost_add(index);
                if(get_compost_tallest_height() >= 6)
                { 
                    gameOver(0);
                }   
            }
        }
        if(ply.score >= 25 && pMode == 0)gameOver(1);
        current = current->next;
        }
  //  }
    return;
    
}

/** Call compost_pile_update() repeatedly in your game-loop. ex: main()
    This function iterate through the fruit list. Add fruits that reach the bottom of the screen
    to the compost pile.
    @return  Number of remaining cities. You might end the game when all cities are demolished.
*/
int gameOver(int con){
    uLCD.locate(5, 7);
  if(con == 1){
    uLCD.filled_rectangle(0, 0, 120, 120, GREEN);
    uLCD.filled_rectangle(10, 10, 110, 110, BLACK);
    uLCD.printf("WINNER");
    end = 1;
    }
  else if(con == 0){

    uLCD.filled_rectangle(0, 0, 120, 120, RED);
    uLCD.filled_rectangle(10, 10, 110, 110, BLACK);    uLCD.printf("YOU LOSE");
    end = 1;
    }   
    return end;
}
void set_random_seed(Timer t) {
    GameInputs inputs; 
    t.start();
    uLCD.printf("Choose Difficulty to start\n\nB1.Easy\nB2.Normal\nB3.Hard\nB4.PractceMode\n");
    while(1){
        inputs = read_inputs();
        if (!inputs.b1){
                        pMode = 0;

            uLCD.baudrate(38400);
            difficultyMode(1);
            break;
        }
        else if(!inputs.b2){
                        pMode = 0;

            uLCD.baudrate(56000);
            difficultyMode(0);
            break;  
        }
        else if(!inputs.b3){
                        pMode = 0;

            uLCD.baudrate(128000);
            difficultyMode(2);
            break;
        }
        else if(!inputs.b4){
            uLCD.baudrate(56000);
            pMode = 1;
            difficultyMode(3);
            break;
        }
}
    uLCD.cls();
    t.stop();
    int seed = t.read_ms();    
    srand(seed);
    }
// ===User implementations end===
