// Include header files for platform
#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "Shiftbrite.h"
#include <vector>

// Include header files for pacman project
#include "globals.h"
#include "map_public.h"
#include "robot.h"

//Platform initialization
DigitalIn left_pb(p24);  // push bottom
DigitalIn right_pb(p21); // push bottom
DigitalIn up_pb(p22);    // push bottom
DigitalIn down_pb(p23);  // push bottom
uLCD_4DGL uLCD(p9,p10,p11); // LCD (serial tx, serial rx, reset pin;)

DigitalOut myled(LED1);

int main()
{
    // Initialize the timer
    /// [Example of time control implementation]
    /// Here is a rough example to implement the timer control <br><br>
    int tick, pre_tick;
    srand (time(NULL));
    Timer timer;
    timer.start();
    tick = timer.read_ms();
    pre_tick = tick;

    // Initialize the buttons
    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed
    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed
    up_pb.mode(PullUp);    //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    down_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed


    /// [Example of the game control implementation]
    /// Here is the example to initialize the game <br><br>
    uLCD.cls();
    map_init();
    robot_init(0,8);
    double x=0;
    double y=8;

    /// 1. Begin the game loop
    while(1) {
        tick = timer.read_ms(); // Read current time

        /// 2. Implement the code to get user input and update the Pacman
        /// -[Hint] Implement the code to move Pacman. You could use either push-button or accelerometer. <br>

        // [Some hints for user-input detection]
        //acc.readXYZGravity(&x,&y,&z); //read accelerometer
        uLCD.locate(0,1);
        uLCD.printf("Score x%4.1f ",1); //You could remove this code if you already make the accelerometer work.
        /// -[Hint] Here is a simple way to utilize the readings of accelerometer:
        ///         If x is larger than certain value (ex:0.3), then make the Pacman move right.
        ///         If x<-0.3, then make it move left. <br>


        if((tick-pre_tick)>500) { // Time step control
            pre_tick = tick; // update the previous tick

            /// 3. Update the Pacman on the screen
            /// -[Hint] You could update the position of Pacman (draw it on the screen) here based on the user-input at step 2. <br>
            if (!up_pb) {                                        //MOVE UP
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (y!=0) {
                    y=y-1;
                } else {
                    y=15;
                }
                wait(0.1);
                robot_init(x,y);
            } else if(!down_pb) {                                    //MOVE DOWN
                robot_clear(x,y);
                map_draw_grid(x,y);
                if(y!=15) {
                    y=y+1;
                } else {
                    y=0;
                }
                wait(0.1);
                robot_init(x,y);
            } else if (!left_pb) {                                  //MOVE LEFT
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=0) {
                    x-=1;
                }
                wait(0.1);
                robot_init(x,y);

            } else if(!right_pb) {                                  //MOVE RIGHT
                robot_clear(x,y);
                map_draw_grid(x,y);
                if (x!=16) {
                    x+=1;
                }
                wait(0.1);
                robot_init(x,y);
            }
            


            /// 4. Implement the code to check the end of game.

        }
    }
}