//Realizado por Luis Malavé en e Smart Labs Electronics

#include "mbed.h"
#include "TextLCD.h"
#include "stm32f103c8t6.h" // en caso de usar Bluepill importar esta libreria para tener compatibilidad con los pines

TextLCD lcd(PB_9, PB_8, PB_7, PB_6, PB_5, PB_4, TextLCD::LCD16x2); // 4bit bus: rs, e, d4,d5,d6,d7, tipo de pantalla
DigitalOut led(PC_13); // usado como monitor de estado de alto voltaje
AnalogIn Vin (PA_0);  // entrada de lectura analogica A0
float realv; // medición de voltaje float

int main() {  // Mi introduciión del programa
    lcd.locate(2,0);
    lcd.printf("e Smart Labs");   // imprime en pantalla
    wait(2);
    while(1) {
      lcd.cls ();  // comando de borrado de pantalla
      lcd.locate(1,0);
      lcd.printf("STM32F103C8T6"); 
      lcd.locate(1,1);
      lcd.printf("Mbed Bluepill"); 
      wait (3);        // espera 3 segundos
      
    lcd.cls();
    wait(0.5);
    while(1){
    realv = (Vin * 200); // calculo de voltaje real
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%.2f Voltios", realv); // imprime el valor de la medición  y el texto en display (%f imprime todos los decimales %.2f solo dos decimales)
    wait_ms(500);
    
    if (realv > 120) { // Si el valor de medición es superior a 120 voltios enciende el Led e imprime en pantalla la condición
          led = 0;  // por la configuración del led PC_13 enciende en estado bajo
          lcd.locate(1,1);
          lcd.printf("Sobrevoltaje", realv);
          wait_ms(500);
        }
        else {
          led = 1;  // apaga el led en estado alto por la configuracion del led PC_13
          lcd.locate(1,1);
          lcd.printf("Voltaje OK", realv);
          wait_ms(3000);
        }
    
   
    
    //lcd.printf("Volt(%f)", Vin.read());
    //wait(2);
      }
    }
}
