#include "keypad.h"

Keypad::Keypad(PinName row3, PinName row2, PinName row1, PinName row0,
               PinName col3, PinName col2, PinName col1, PinName col0,
               int debounce_ms):
        _row0(row0), _row1(row1), _row2(row2), _row3(row3),
        _cols(col0, col1, col2, col3) {
    _debounce = debounce_ms;
    _setupRiseTrigger();
}

void Keypad::Start(void) {
    _cols = 0x0F;
}

void Keypad::Stop(void) {
    _cols = 0x00;
}

void Keypad::CallAfterInput(uint32_t (*fptr)(uint32_t index)) {
    _input.attach(fptr);
}

void Keypad::_callback(int row, InterruptIn &therow) {
    wait_ms(_debounce);
    if (therow != 1)
        return;

    int c = -1;
    _cols = _cols & 0x0E;
    if (therow == 0)
        c = 0;
    else {
        _cols = _cols & 0x0D;
        if (therow == 0)
            c = 1;
        else {
            _cols = _cols & 0x0B;
            if (therow == 0)
                c = 2;
            else
                c = 3;
        }
    }
    _input.call(row * 4 + c);
    Start(); // Re-energize all columns
}

void Keypad::_cbRow0Rise(void) {
    _callback(0, _row0);
}
void Keypad::_cbRow1Rise(void) {
    _callback(1, _row1);
}
void Keypad::_cbRow2Rise(void) {
    _callback(2, _row2);
}
void Keypad::_cbRow3Rise(void) {
    _callback(3, _row3);
}

void Keypad::_setupRiseTrigger(void) {
    _row0.rise(this, &Keypad::_cbRow0Rise);
    _row1.rise(this, &Keypad::_cbRow1Rise);
    _row2.rise(this, &Keypad::_cbRow2Rise);
    _row3.rise(this, &Keypad::_cbRow3Rise);
}