#include "mbed.h"
#include <Pulse1.h>

PulseInOut irda(PTD5);
Serial pc(USBTX, USBRX);
DigitalOut l0(LED1);
DigitalOut l1(LED2);
DigitalOut l2(LED3);

int header =0;
const int head_H = 2964; //+20% medida con osciloscopio en microsegundos
const int head_L = 1976;//-20%  medida con osciloscopio
int i=0;
const int T_alto=1200;//ponga su tiempo de la prueba
const int T_bajo=600;//ponga su tiempo de la prueba
const int num_bits = 21;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
int n1[20],n2[20],n3[20];

int main(){
    n1[0]=n1[1]=n1[2]=n1[3]=n1[4]=n1[5]=n1[6]=n1[7]=n1[9]=n1[13]=n1[14]=n1[16]=n1[17]=n1[19]=0;
    n1[8]=n1[10]=n1[11]=n1[12]=n1[15]=n1[18]=1;
    n2[1]=n2[3]=n2[4]=n2[5]=n2[6]=n2[7]=n2[1]=n2[9]=n2[13]=n2[14]=n2[16]=n2[17]=n2[19]=0;
    n2[8]=n2[10]=n2[11]=n2[12]=n2[15]=n2[18]=n2[0]=1;
    n3[0]=n3[2]=n3[3]=n3[4]=n3[5]=n3[6]=n3[7]=n3[9]=n3[13]=n3[14]=n3[16]=n3[17]=n3[19]=0;
    n3[8]=n3[10]=n3[11]=n3[12]=n3[15]=n3[18]=n3[1]=1;
    int w,e,r;
    w=e=r=0;
    l0=l1=l2=1;
    while(1){
        ini1: header=0;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;
      
        seguir:
        wait_us(300);

        for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_low_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(300);   
        }
        
        wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla 

        for(i=0;i<(num_bits-1);++i){  
            if(num[i] > ((T_alto+T_bajo)/2)) num[i]=1;
            else num[i]=0;
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==n1[i])w++;
        }

        if(w==20){
            l0=!l0;
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==n2[i])e++;
        }

        if(e==20){
            l1=!l1;
        }
        for(i=0;i<(num_bits-1);++i){
            if(num[i]==n3[i])r++;
        }

        if(r==20){
            l2=!l2;
        }
        w=e=r=0;
      }
}