#include "mbed.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void update_leds (int myleds)
{
  // update the LEDs
  myled1 = myleds  & 1;
  myled2 = (myleds & 2) >> 1;
  myled3 = (myleds & 4) >> 2;
  myled4 = (myleds & 8) >> 3;
}

int main() 
{
    unsigned int    count, count_up, speed_up   = 0  ;
    float           count_interval              = 0.1;

    count_up = ~ count_up;

    while(1) 
    {
        // update LEDs with the current count value
        update_leds (count);
        
        // count up or down depending on the value of count_up
        if (count_up)
            count++;
        else
            count--;
        
        // interval to next count    
        wait(count_interval);
        
        // update the count interval when the LED count gets to 16
        // decrement the interval every 16 lots of counts
        if (speed_up && count % 16 == 0)
          count_interval /= 2;
        else if (count % 16 == 0)
          count_interval *= 2;   
        
        if (count % 256 == 0)
          speed_up = ~ speed_up;
        
        // change the count direction every 32 lots of counts
        if (count % 512 == 0)
          count_up = ~ count_up;
          
    }
}
