#include "mbed.h"
#include "SRF05.h"
#include "SRF02.h"

Serial pc(USBTX, USBRX);
Serial bt(p13, p14);

DigitalOut led (LED1);
SRF05 srf05(p7, p8);
SRF02 srf02(p9, p10);

char input();
void avstand();
void detektor(float);
void hastighet();
void triangulering();

int main()
{
    float y;
    while(1) {
        char kom1 [] = {"\n\nMenu\n1)\tMeassure Distance\n2)\tMotion Detection\n3)\tMeassure Velocity\n4)\tPlacement\n"};
        pc.printf("%s", kom1);
        bt.printf("%s", kom1);
        while (pc.readable() == 0 && bt.readable() == 0) {}
        switch (input()) {
            case('1'): {
                char kom2 [] = {"\nPress 'y' to meassure distance\nPress 'n' to return to the menu\nThe bargraph will light up according to how close the object is\n1 LED equals 35cm\n"};
                pc.printf("%s", kom2);
                bt.printf("%s", kom2);
                avstand();
                break;
            }
            case('2'): {
                char kom3 [] = {"\nLights will flash when a motion is detected\nPress 'n' to return to the menu\n"};
                pc.printf("%s", kom3);
                bt.printf("%s", kom3);
                y = srf05.read();
                detektor(y);
                break;
            }
            case('3'): {
                char kom4 [] = {"\nThis feature meassures the velocity of any movement towards Ultra-Sonic Ranger SRF05\nPress 'n' to return to the menu\n"};
                pc.printf("%s", kom4);
                bt.printf("%s", kom4);
                hastighet();
                break;
            }
            case('4'): {
                char kom5 [] = {"\nThis feature returns the positon of an object in a 2D-table\nEach 'O' represents 10square centimeters and 'X' represents the detected object\nPlace componentes according to the datasheet\n"};
                pc.printf("%s", kom5);
                bt.printf("%s", kom5);
                triangulering();
                break;
            }
            default:
                char kom6 [] = {"\nERROR: Invalid value\n"};
                pc.printf("%s", kom6);
                bt.printf("%s", kom6);
        }
    }
}

/* Char Input() er en funksjon som avgjør om input kommer fra bluetooth eller pc. Deretter returnerer den input verdien. */

char input()
{
    if(pc.readable())
        return getchar();
    else if (bt.readable())
        return bt.getc();
    else
        return 1;
}

/* Void avstand() er en funksjon som måler avstand til en gjenstand innenfor rekkevidden til ultralyd sensoren. Avstanden sendes til pc & bluetooth i cm. */

void avstand()
{
    DigitalOut bar[] = {NC, p21, p22, p23, p24, p25, p26, p27, p28, p29, p30};
    char a;
    float z, y;
    int n = 0;

    while (a != 'n') {
        while (pc.readable() == 0 && bt.readable() == 0) {}
        a = input();
        if (a == 'y') {
            y = srf05.read();
            if (y > 350) {
                char kom1 [] = {"\nDetection area is exceeded (350cm)\n"};
                pc.printf("%s", kom1);
                bt.printf("%s", kom1);
                y = z;
            } else {
                z = y;
                pc.printf("\nMeassurement (%d):\t%.2fcm\n",n, y);
                bt.printf("\nMeassurement (%d):\t%.2fcm\n",n, y);
            }
            for(int x = 1; x <= 10; x++) {
                (x*35 < y) ?   bar[x] = 0  :   bar[x] = 1;
            }
            n++;
            wait_ms (50);
        } else if (a != 'n') {
            char kom3 [] = {"\nInvalid input\n"};
            pc.printf("%s", kom3);
            bt.printf("%s", kom3);
        }
    }
    for(int x = 1; x <= 10; x++)
        bar[x] = 0;
}

/* Funksjonen Void detektor() er en funksjon som detekterer bevegelse. LED blinker ved deteksjon. */

void detektor(float y)
{
    int b = 0;
    while (input() != 'n') {
        if (y+2 < srf05.read() || y-2 > srf05.read()) {
            led = !led;
            if (b == 0) {
                char kom1 [] = {"\nMotion Detected\n"};
                pc.printf("%s", kom1);
                bt.printf("%s", kom1);

                b = 1;
            }
        } else
            b = led = 0;
        wait_ms (50);
    }
}

/* Funksjonen Void Hastighet() måler hastigheten til et objekt foran ultralyd sensoren. Hastigheten skrives til pc & bluetooth i km/t. */

void hastighet ()
{
    Timer t;
    float start, stopp, fart;
    while(input() != 'n') {
        t.start();
        start = srf05.read();
        while (t.read() < 0.25 && srf05.read() > 10) {}
        t.stop();
        stopp = srf05.read();
        fart = (start - stopp)*(3.6/(t.read()*100));
        if (stopp < 10) {
            char kom1 [] = {"\nERROR: Closer than 10cm from the Ultra Sonic Ranger."};
            pc.printf("%s", kom1);
            bt.printf("%s", kom1);
            wait_ms (250);
        }
        if (0.5 < fart && start < 350 && stopp < 350) {
            pc.printf("\nVelocity is = %0.2f km/t", fart);
            bt.printf("\nVelocity is = %0.2f km/t", fart);
        }
        t.reset();
    }
}

/*Funksjonen plasseringiplan måler avstanden til et objekt i målesonen, fra to forskjellige vinkler. Avstanden til objektet plasseres i et 2D-plan. Størrelsen på planet er 100cm langs x akse og 50cm langs y akse.*/

void triangulering ()
{
    char _2DplanX[12] = {'|','O','O','O','O','O','O','O','O','O','O','|'};
    char _2Dplan[12] = {'|','O','O','O','O','O','O','O','O','O','O','|'};
    double vinkel_b, vinkel_a, vinkel_x, vinkel_y, y_akse, x_akse, hyp, PI;
    int a, b, c, n, m;
    float d;
    PI = acos(-1.0);
    hyp = 305.0;
    char h;
    while (h != 'n') {
        while (pc.readable() == 0 && bt.readable() == 0) {}
        h = input();
        if (h == 'y') {
            d = 0.0;
            b = n = m = 0;
            while (d < 180.0 || d > 280.0 && n < 10) {
                d = srf05.read();
                n++;
                wait_ms (100);
            }
            while (b < 150 || b > 250 && m < 10) {
                b = srf02.getDistanceCm();
                wait_ms (250);
                m++;
            }
            if (n == 10 || m == 10) {
                char kom1 []= {"\nERROR: No object detected within the bouandaries\n"};
                pc.printf("%s", kom1);
                bt.printf("%s", kom1);
            } else {
                vinkel_b = acos((hyp*hyp+d*d-b*b)/(2.0*hyp*d));
                vinkel_a = acos((hyp*hyp+b*b-d*d)/(2.0*hyp*b));
                vinkel_y = PI-0.8076167287-vinkel_b;
                if( vinkel_y > PI/2.0)
                    vinkel_y = 0.8076167287+vinkel_b;
                y_akse = sin(vinkel_y)*d;
                vinkel_x = PI-0.7631795981-vinkel_a;
                if( vinkel_x > PI/2.0)
                    vinkel_x = 0.7631795981+vinkel_a;
                x_akse = sin(vinkel_x)*b;
                for (c = 1; c < 11; c++) {
                    if (((c-1)*10+150) <= x_akse && x_akse < (c*10+150))
                        _2DplanX[c] = 'X';
                    else
                        _2DplanX[c] = 'O';
                }
                for (c = 280; c >= 190; c=c-10) {
                    if (c-10 <= y_akse && y_akse < c) {
                        for(a = 0; a < 12; a++) {
                            pc.printf("%c",_2DplanX[a]);
                            bt.printf("%c",_2DplanX[a]);
                        }
                    } else {
                        for(a = 0; a < 12; a++) {
                            pc.printf("%c",_2Dplan[a]);
                            bt.printf("%c",_2Dplan[a]);
                        }
                    }
                    char kom2 []= {"\n"};
                    pc.printf("%s", kom2);
                    bt.printf("%s", kom2);
                }
            }
        } else if (h != 'n') {
            char kom3 [] = {"\nInvalid input\n"};
            pc.printf("%s", kom3);
            bt.printf("%s", kom3);
        }
    }
}