#include "mbed.h"
#include "XBeeLib.h"
#include "rtos.h"
#if defined(ENABLE_LOGGING)
#include "DigiLoggerMbedSerial.h"
using namespace DigiLog;
#endif


#define REMOTE_NODE_ADDR64_MSB  ((uint32_t)0x0013A200)

//#error "Replace next define with the LSB of the remote module's 64-bit address (SL parameter)"
#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x40E779AF)

#define REMOTE_NODE_ADDR64      UINT64(REMOTE_NODE_ADDR64_MSB, REMOTE_NODE_ADDR64_LSB)

using namespace XBeeLib;

//feux gauche
    //rouge
DigitalOut feu_rouge(p30);
    //orange
DigitalOut feu_orange(p28);
    //vert
DigitalOut feu_vert(p26);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
int nbVoiture = 0;
Thread t_affichage;

Thread t_nbVoitureBouton;
Thread t_nbVoitureCapteur;
Thread t_feuRouge;
Timer timer;

DigitalIn boutonPlus(p24);
DigitalIn boutonMoins(p23);
AnalogIn signal(p20);

char moins[]="m"; // m comme "moins" - une voiture de moins
char plus[]="p"; // p comme "plus" - une voiture de plus
char rouge[]="r"; // r comme "rouge" - confirmation que le feu est rouge

int compteur =0;
int wait_front_montant = 0;
int wait_front_descendant  = 0;
double frequence =0;

Serial *log_serial;
XBeeZB xbee = XBeeZB(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);
const RemoteXBeeZB remoteDevice = RemoteXBeeZB(REMOTE_NODE_ADDR64);

/** Callback function, invoked at packet reception */
static void receive_cb(const RemoteXBeeZB& remote, bool broadcast, const uint8_t *const data, uint16_t len)
{
    const uint64_t remote_addr64 = remote.get_addr64();

    log_serial->printf("\r\nGot a %s RX packet [%08x:%08x|%04x], len %d\r\nData: ", broadcast ? "BROADCAST" : "UNICAST", UINT64_HI32(remote_addr64), UINT64_LO32(remote_addr64), remote.get_addr16(), len);

    if (data[0]==0x72){
        t_feuRouge.signal_set(0x1);
    }
    else if (data[0]==0x76){
        feu_rouge = 0;
        feu_orange = 0;
        feu_vert = 1;
    }
        
    log_serial->printf("\r\n");
}


static void send_explicit_data_to_remote_node(XBeeZB& xbee, const RemoteXBeeZB& RemoteDevice,const char * data)
{
    const uint8_t dstEP = 0xE8;
    const uint8_t srcEP = 0xE8;
    const uint16_t clusterID = 0x0011;
    const uint16_t profileID = 0xC105;

    const TxStatus txStatus = xbee.send_data(RemoteDevice, dstEP, srcEP, clusterID, profileID, (const uint8_t *)data, strlen(data));  
}

void connect_Xbee()
{
    log_serial = new Serial(DEBUG_TX, DEBUG_RX);
    log_serial->baud(9600);
    log_serial->printf("Sample application to demo how to receive unicast and broadcast data with the XBeeZB\r\n\r\n");
    log_serial->printf(XB_LIB_BANNER);
    
    #if defined(ENABLE_LOGGING)
    new DigiLoggerMbedSerial(log_serial, LogLevelInfo);
    #endif

    /* Register callbacks */
    xbee.register_receive_cb(&receive_cb);

    RadioStatus const radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);

    /* Wait until the device has joined the network */
    log_serial->printf("Waiting for device to join the network: ");
    while (!xbee.is_joined()) {
        wait_ms(1000);
        log_serial->printf(".");
    }
    log_serial->printf("OK\r\n");
}

void set_feuRouge()
{
   while(1)
   {
      Thread::signal_wait(0x1);
      if (feu_rouge!=1){
          feu_vert = 0;
          feu_orange = 1;
          Thread::wait(2000);
          feu_orange = 0;
          feu_rouge = 1;
      }
      send_explicit_data_to_remote_node(xbee, remoteDevice,rouge);
   }
}

void nbVoitureBouton() {
    //TO DO : 
    // - faire un compteur de voitures interne au recepteur et envoyer ce nombre 
    //   au coordinateur -> plus fiable en cas de perte de donnees dans un envoi
    // - faire un buffer pour envoyer les donnees
    //
    while(1) {
        if(boutonPlus){
            nbVoiture++;
            send_explicit_data_to_remote_node(xbee, remoteDevice,plus); 
            Thread::wait(500);
        }
        if(boutonMoins){
            nbVoiture--;
            send_explicit_data_to_remote_node(xbee, remoteDevice,moins);  
            Thread::wait(500);
        }        
    }
}

void nbVoitureCapteur() {
    while(1){
        
        //lecture valeur analogique du capteur à effet doppler hb100
        int value = signal.read_u16();
        
        // si inferieur a 100 on commence la mesure de la frequence du signal
        if (signal.read_u16()<100&&compteur==0){
            timer.start();
            compteur++;
            wait_front_montant = 1;
        }
          
        // on attend un front montant 
        else if (signal.read_u16()>45000&&wait_front_montant==1){
            wait_front_montant=0;
            wait_front_descendant  = 1;
        }
        
        //deuxieme front dessandant, on a mesurer la frequence , on répète l'opération 3 fois (jusqu'a compteur == 5 )
        else if (signal.read_u16()<100&&wait_front_descendant==1){
            wait_front_descendant  = 0;
            wait_front_montant=1;
            timer.stop();
            double t = timer.read();
            frequence = frequence + 1/t;
            compteur++;
            timer.reset();
            timer.start();
        }
        
       
        if(compteur==5){
             // on fait la moyenne de la somme des trois frequences mesurées
            frequence = frequence/3;
            // on calcule la vitesse a partir d'une formule donnée dans la doc du capteur
            double vitesse = frequence*2/19.49;
            // si la vitesse est superieur à 1km/h, on considère qu'une voiture est passer 
            if (vitesse>1){
                send_explicit_data_to_remote_node(xbee, remoteDevice,plus);
                nbVoiture++;
                printf("vitesse : %f KM/H \r\n",vitesse);
                Thread::wait(1000);
            }
            compteur=0;
            timer.reset();
        }
    }
}

void affichage(){
    while(1){
        int a = nbVoiture;
        if(a>=8){
            led4=1;
            a-=8;
        }
        else{led4=0;}
        if(a>=4){
            led3=1;
            a-=4;
        }
        else{led3=0;}
        if(a>=2){
            led2=1;
            a-=2;
        }
        else{led2=0;}
        if(a>=1){
            led1=1;
            a-=1;
        }
        else{led1=0;}
    }
}

int main()
{
    connect_Xbee();
    t_nbVoitureBouton.start(nbVoitureBouton);
    t_nbVoitureCapteur.start(nbVoitureCapteur);
    t_feuRouge.start(set_feuRouge);
    t_affichage.start(affichage);
    while (true) {
        uint32_t receive_value = xbee.process_rx_frames();
    }
}
