#include "mbed.h"
#include "rtos.h"

DigitalOut dout(p18);
InterruptIn button(p5);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut flash(LED4);
DigitalIn pin12(p12);

int periode = 1; //10ms
int periode_reception = 30;
bool PREAMBULE[] = {0,1,0,1,0,1,0,1};
bool START_END[] = {0,1,1,1,1,1,1,0};
Thread envoi_t;
Thread reception_t;
Thread detection_t;

typedef struct {
    int time;
    bool front;
} message_t;

Mail<message_t,128> mail_box;
Timer timer;
int etat;
const int longMessage = 128;
bool messageUtile[longMessage] = {0,0,1,0,1,1,1,0,
                        1,0,1,0,0,0,0,0,
                        0,0,1,1,1,0,1,0,
                        1,1,0,0,0,1,1,0,
                        0,1,0,1,1,0,1,1,
                        1,0,1,0,1,1,1,0,
                        0,0,1,0,1,0,0,0,
                        1,1,0,1,0,1,1,0,
                        0,0,1,0,1,1,1,0,
                        1,0,1,0,0,0,0,0,
                        0,0,1,1,1,0,1,0,
                        1,1,0,0,0,1,1,0,
                        0,1,0,1,1,0,1,1,
                        1,0,1,0,1,1,1,0,
                        0,0,1,0,1,0,0,0,
                        1,1,0,1,0,1,1,0};

//CRC16 (détection des erreurs) ----------------------------------------------------------------------------------------------------
unsigned short crc16(bool* data_p, int length){
    unsigned char x;
    unsigned short crc = 0xFFFF;

    while (length--){
        x = crc >> 8 ^ *data_p++;
        x ^= x>>4;
        crc = (crc << 8) ^ ((unsigned short)(x << 12)) ^ ((unsigned short)(x <<5)) ^ ((unsigned short)x);
    }
    return crc;
}

//convert length from int to binary -----------------------------------------------------------------------------------------------------
bool r;
void int_to_bin(bool bin[8], int length){ //Fonctionne
    int i = 0;
    while(length >0 || i<8){
        r = length%2;
        length/=2;
        bin[7-i]=r;
        i++;
    }
    while(i<8){
        bin[i]=0;
        i++;   
    }
}

void int_to_bin2(bool bin[8], int length){ //Fonctionne
    int i = 0;
    while(length >0 && i<8){
        r = length%2;
        length/=2;
        bin[7-i]=r;
        i++;
    }
    while(i<8){
        bin[i]=0;
        i++;   
    }
}

//convert to Manchester ------------------------------------------------------------------------------------------------
void convertBitToManchester(bool *manchester, bool bit){ //Fonctionne
    if(bit == 0){
        manchester[0]=0;
        manchester[1]=1;
    } 
    else if(bit == 1){
        manchester[0]=1;
        manchester[1]=0; 
    }
}

void convertByteToManchester(bool *manchester, bool byte[8]){ //Fonctionne
    for(int i=0; i<8; i++){
        if(byte[i] == 0){
            manchester[i*2]=0;
            manchester[i*2+1]=1;
        } 
        else if(byte[i] == 1){
            manchester[i*2]=1;
            manchester[i*2+1]=0; 
        }     
    }     
}

void convertMessageToManchester(bool *manchester, bool *message, int length){
        for(int i=0; i<length; i++){
            if(message[i] == 0){
                manchester[i*2]=0;
                manchester[i*2+1]=1;
            } 
            else if(message[i] == 1){
                manchester[i*2]=1;
                manchester[i*2+1]=0; 
            }   
        }     
}

//création d'une trame  --------------------------------------------------------------------------------------------------------------
void creationTrame(bool *message, int length){ //Fonctionne
    bool bin[8];
    int_to_bin(bin, length);
    for(int i=0; i<8; i++){
        *message=PREAMBULE[i];
        message++;
    }
    for(int i=0; i<8; i++){
        *message=START_END[i];
        message++;
    }
    for(int i=0; i<8; i++){
        *message=0;
        message++;
    }
    for(int i=0; i<8; i++){
        *message=bin[i];
        message++;
    }
    for(int i=0; i<sizeof(messageUtile); i++){
        *message=messageUtile[i];
        message++;        
    }
    //CRC16
    unsigned short crc = crc16(messageUtile, (int)sizeof(messageUtile));
    printf("\r\n -----------------CRC ENVOYE: %d-------------\r\n", crc);
    int_to_bin2(bin, crc);
    for(int i=0; i<8; i++){
        *message=bin[i];
        //*message=0;
        message++;      
    }
    for(int i=0; i<8; i++){
        *message=START_END[i];
        message++;
    }            
}

//Envoi d'une trame ----------------------------------------------------------------------------------------------------------------
void envoiTrame(){
    bool app=false;
    int length3 = sizeof(messageUtile);
    bool message3[length3+6*8];
    bool manchester3[(length3+6*8)*2];
    
    creationTrame(message3,length3);
    convertMessageToManchester(manchester3, message3,length3+6*8);
    while(1){
        if(pin12 && !app){
            app=true;
            for(int i=0; i<sizeof(manchester3); i++){
                dout = manchester3[i];
                Thread::wait(periode);   
            }
        }
        else if(!pin12 && app){
            app=false;
        }    
    }
}


//Réception des trames
void receptionTrames() {
    int compteur = 0;
    int prev_time;
    int t;
    bool preambule[8];
    bool start[8];
    bool flag[8];
    bool longueur[8];
    bool message[80*8];
    bool checksum[8];
    bool end[8];
    int longInt;
    bool bin2[8];
    int temps =0;
    int tMax;
    int tMin;
    while(1){
        osEvent evt = mail_box.get();
        if (evt.status == osEventMail) {
            message_t *f = (message_t*)evt.value.p;
            led3 = f->front;
            t = f->time;
            if(etat==0) {
                if(f->front == 0){
                    compteur=0;
                    timer.start();
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        preambule[compteur] = f->front;
                        prev_time = t; 
                        compteur++;
                        etat = 1;
                        printf("-----ETAT 1-----\r\n");
                }
            }
            
            else if(etat==1) {
                if(f->front==1){
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        preambule[compteur] = f->front;
                        prev_time = t; 
                        compteur++;
                        etat = 2;
                        printf("-----ETAT 2-----\r\n");
                }
            }
            
            else if(etat==2) {
                    printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                    preambule[compteur] = f->front;
                    temps += t-prev_time;
                    prev_time = t; 
                    compteur++;
            }
            
            else if(etat ==3) {
                if(((t-prev_time)<=tMax)&& ((t-prev_time)>=tMin)){
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        start[compteur-8] = f->front;
                        prev_time = t; 
                        compteur++;
                }
            }
            
            else if(etat ==4) {
                if(((t-prev_time)<=tMax)&& ((t-prev_time)>=tMin)){
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        flag[compteur-16] = f->front;
                        prev_time = t; 
                        compteur++;
                }
            }
            
            else if(etat ==5) {
                if(((t-prev_time)<=tMax)&& ((t-prev_time)>=tMin)){
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        longueur[compteur-24] = f->front;
                        prev_time = t; 
                        compteur++;
                }
            }
            else if(etat ==6) {
                if(((t-prev_time)<=tMax)&& ((t-prev_time)>=tMin)){
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        message[compteur-32]= f->front;
                        prev_time = t; 
                        compteur++;
                }
            } 
            else if(etat ==7) {
                if(((t-prev_time)<=tMax)&& ((t-prev_time)>=tMin)){
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        checksum[compteur-32-longInt]= f->front;
                        prev_time = t; 
                        compteur++;
                }
            } 
            else if(etat ==8) {
                if(((t-prev_time)<=tMax)&& ((t-prev_time)>=tMin)){
                        printf("%d Time : %d , compteur: %d\r\n", f->front, t, compteur);
                        end[compteur-40-longInt]= f->front;
                        prev_time = t; 
                        compteur++;
                }
            } 
            mail_box.free(f);
        }
        
        if((compteur ==8) && (etat ==2)){
            etat = 3;
            for(int i=0; i<8;i++){
                if((preambule[i]!= PREAMBULE[i]) && (etat !=0 ))
                {
                    etat =0;
                    printf("\r\n------Pas le bon PREAMBULE------\r\n");
                }
                printf("%d", preambule[i]);    
            }
            printf("\r\n");
            if(etat != 0)
            {
                temps /=6;
                tMin = 0.75*temps;
                tMax = 1.25*temps;
                printf("-----ETAT 3 %d-----\r\n", temps);
            }
        }
        else if((compteur ==16) && (etat == 3)) {
            etat =4;
            for(int i=0; i<8;i++){
                if((start[i]!= START_END[i]) && (etat != 0))
                {
                    etat =0;
                    printf("\r\n------Pas le bon START------\r\n");
                }
                printf("%d", start[i]);    
            }
            printf("\r\n");
             if(etat != 0)
            {
                printf("-----ETAT 4-----\r\n");
            }
        }
        else if((compteur==24) && (etat ==4)) {
            for(int i=0; i<8;i++){
                printf("%d", flag[i]);    
            }
            printf("\r\n");
            etat =5;
            printf("-----ETAT 5 -----\r\n");
        }
        else if((compteur==32) && (etat ==5)) {
            longInt=0;
            for(int i = 0; i<8; i++) {
                longInt = longInt*2+longueur[i];    
            }
            printf("%d\r\n", longInt);
            etat =6;
            printf("-----ETAT 6 -----\r\n");
        }
        else if((compteur==32+longInt) && (etat ==6)) {
            for(int i=0; i<longInt;i++){
                printf("%d", message[i]);    
            }
            printf("\r\n");
            etat =7;
            printf("-----ETAT 7-----\r\n");
        }
        
        else if((compteur == 40 +longInt) && (etat ==7)) {
            etat =8;
            unsigned short crc = crc16(message, longInt);
            printf("\r\n -----------------CRC RECALCULE: %d-------------\r\n", crc);
            int_to_bin2(bin2, crc);
            for(int i=0; i<8;i++){
                printf("%d", bin2[i]);
                if((bin2[i] != checksum[i]) && (etat !=0)) {
                    etat =0;
                    printf("\r\n------Pas le bon CRC------\r\n");
                }
            }
            
            printf("\r\n");
            if(etat != 0)
            {
                printf("-----ETAT 8-----\r\n");
            }
        }
        else if((compteur == 48 +longInt) && (etat ==8)) {
            for(int i=0; i<8;i++){
                if(end[i]!= START_END[i])
                {
                    etat =0;
                    printf("\r\n------Pas le bon END------\r\n");
                }
                printf("%d", end[i]);    
            }
            printf("\r\n");
            etat =0;
            printf("-----ETAT 0-----\r\n");
        }        
    }
}

void rise() {
    led1 = !led1;
    message_t *a = mail_box.alloc();
    a->time = timer.read_ms();;
    a->front = 0; //Si rise, il s'agit d'un 0 en Manchester
    mail_box.put(a);
}

void fall() {
    led2 = !led2;
    message_t *a = mail_box.alloc();
    a->time = timer.read_ms();;
    a->front = 1; //Si fall, il s'agit d'un 1 en Manchester
    mail_box.put(a);
}
 

int main() {
    printf("\r\n\r\n**********Debut**********\r\n");
    int length = sizeof(messageUtile);
    bool message[length+6*8]; //Taille total du message avec les entêtes
    bool manchester[(length+6*8)*2];
    creationTrame(message,length);
    
    //Afficher les bits envoyés
    printf("\r\nMessage : \r\n");
    for(int i=0; i<sizeof(message); i++){
       if(i>0 && i%8 == 0){
           printf(" ");
       }
       printf("%d",message[i]);
    }
    printf("\r\n");
    
    convertMessageToManchester(manchester, message, length+6*8);
    
    //Affiche les bits en manchester
    printf("\r\nMessage Manchester: \r\n");
    for(int i=0; i<sizeof(manchester); i++){
       if(i>0 && i%16 == 0){
           printf("\r\n");
       }
       if(i>0 && i%2 == 0){
           printf(" ");
       }
       printf("%d",manchester[i]);
    }
    printf("\r\n");
    
    //Démarrage des threads
    envoi_t.start(envoiTrame);
    reception_t.start(receptionTrames);
    
    button.rise(&rise);  // attach the address of the flip function to the rising edge
    button.fall(&fall);
    while(1) {           // wait around, interrupts will interrupt this!
        flash = !flash;
        wait(0.25);
        //Permet d'indiquer si l'application tourne
    }
}
 