#include "mbed.h"
#include "adc.h"
#include "MCP23S17.h"
#include "rtos.h"
#include "ESP8266.h"
#define MN 256 
#define SAMPLE_RATE   48000

RawSerial pc(USBTX, USBRX); // tx, rx
DigitalOut led1(LED1);
DigitalOut led4(LED4);

// wifi chip
ESP8266 esp(p28, p27, p26, "HTC U11", "leojoey82"); // tx, rx, reset, SSID, password
#define RCV_BUF_SIZE 4095
char rcv[RCV_BUF_SIZE];
volatile int rcv_tail = 0;
volatile int rcv_head = 0;

/* Circular buffer to hold commands */
static int COM_BUF_SIZE = 100;
volatile char * command_queue;
volatile int queue_tail = 0;
volatile int queue_head = 0;

// Create SPI bus
SPI spi(p5, p6, p7);

DigitalOut layer0(p24);
DigitalOut layer1(p23);
DigitalOut layer2(p22);
DigitalOut layer3(p21);
AnalogIn ain(p18);

char Opcode = 0x40;
MCP23S17 chip = MCP23S17(spi, p20, Opcode);
Timer timer;
Ticker ticker;

int Counter = 0;
int led_control = 4;
int16_t Buffer[5000];
unsigned char PowerInt[MN/2];
ADC adc(SAMPLE_RATE, 1);
float g;

void sample_ADC(int chan, uint32_t value) {
    float s;
    s = adc.read(p19);
    Counter += 1;
    g = abs(s-2048);
    g = g/2048;   
}

void LED_Thread(void const *args) {
    chip.write(PORT_A, 0x00);
    chip.write(PORT_B, 0x00);
    layer0 = 1;
    layer1 = 0;
    layer2 = 0;
    layer3 = 0;
//  Set all 8 Port A bits to output direction
    chip.direction(PORT_A, 0x00);
//  Set all 8 Port B bits to output direction
    chip.direction(PORT_B, 0x00);
    unsigned char c[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
    while(1){
        if (queue_tail < queue_head) {
            /* Save comand in temporary char variable */
            char command = command_queue[queue_tail];
            pc.printf("%c", command);
            
            /* Null the command consumed */
            command_queue[queue_tail] = '\0';
            
            if (command == 'N') {
                led_control = 0;
                pc.printf("\r\n----Switch to None Mode----\r\n");
            } else if (command == 'B') {
                led_control = 1;
                pc.printf("\r\n----Switch to Basic Mode----\r\n");
            } else if (command == 'P') {
                led_control = 2;
                pc.printf("\r\n----Switch to Pattern Mode----\r\n");
            } else if (command == 'R') {
                led_control = 3;
                pc.printf("\r\n----Switch to Random Mode----\r\n");
            }else if (command == 'S') {
                led_control = 4;
                pc.printf("\r\n----Switch to Screensaver Mode----\r\n");
            }
            /* Increment command index in circular buffer */
            queue_tail = (queue_tail + 1) % COM_BUF_SIZE;
        }
            
        switch(led_control){
            case 0: // None Mode
                layer0 = 0; 
                layer1 = 0; 
                layer2 = 0; 
                layer3 = 0;
                //for(int i = 0; i <=7; i++) {
//                    chip.write(PORT_A, c[i]); //A loop
//                    Thread::wait(10);
//                }
                chip.write(PORT_A, 0x00);
                Thread::wait(10);
               // for(int i = 0; i <=7; i++){
//                    chip.write(PORT_B, c[i]); //A loop
//                    Thread::wait(10);
//                }
                chip.write(PORT_B, 0x00); //CLEAR
                break;
            case 1: //Standard Mode (Basic)
//                pc.printf("%f\n",g);
                chip.write(PORT_A, 0xFF);
                chip.write(PORT_B, 0xFF);
                if(g >= 0 && g < .9){
                    layer3 = 1;
                }else{
                    layer3 = 0;   
                }    
                if(g > .9 && g < .94){
                    layer2 = 1;
                }else{
                    layer2 = 0;   
                }    
                if(g > .94 && g < .995){
                    layer1 = 1;
                }else{
                    layer1 = 0;   
                }    
                if(g > .995 && g <= 1){
                    layer0 = 1;
                }else{
                    layer0 = 0;   
                } 
                break;
            case 2: //Standard + Screensaver
//                pc.printf("%f\n",g);
                if(g >= 0 && g < .9){
                    layer3 = 1;
                }else{
                    layer3 = 0;   
                }    
                if(g > .9 && g < .94){
                    layer2 = 1;
                }else{
                    layer2 = 0;   
                }    
                if(g > .94 && g < .995){
                    layer1 = 1;
                }else{
                    layer1 = 0;   
                }    
                if(g > .995 && g <= 1){
                    layer0 = 1;
                }else{
                    layer0 = 0;   
                } 
                for( int i = 0; i <=7; i++){chip.write(PORT_A, c[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_A, 0x00);
                for( int i = 0; i <=7; i++){chip.write(PORT_B, c[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_B, 0x00); //CLEAR
                break;
            case 3: //Standard + Screensaver {{RANDOM}}
                char c_rand[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
//                pc.printf("%f\n",g);
                if(g >= 0 && g < .9){
                    layer3 = 1;
                }else{
                    layer3 = 0;   
                }    
                if(g > .9 && g < .94){
                    layer2 = 1;
                }else{
                    layer2 = 0;   
                }    
                if(g > .94 && g < .995){
                    layer1 = 1;
                }else{
                    layer1 = 0;   
                }    
                if(g > .995 && g <= 1){
                    layer0 = 1;
                }else{
                    layer0 = 0;   
                } 
                for (int i=0; i<7; i++) {
                    int r = rand() % 7;  // generate a random position
                    int temp = c_rand[i]; c_rand[i] = c_rand[r]; c_rand[r] = temp;
                }
                for( int i = 0; i <=7; i++){chip.write(PORT_A, c_rand[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_A, 0x00);
                for( int i = 0; i <=7; i++){chip.write(PORT_B, c_rand[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_B, 0x00); //CLEAR
                break;
            case 4: //Screensaver
                for(int n = 0; n<= 3; n++){
                    switch(n){
                        case 1: layer0 = 0; layer1 = 1; layer2 = 0; layer3 = 0;
                            break;
                        case 2: layer0 = 0; layer1 = 0; layer2 = 1; layer3 = 0;
                            break;
                        case 3: layer0 = 0; layer1 = 0; layer2 = 0; layer3 = 1;
                            break;
                        default: layer0 = 1; layer1 = 0; layer2 = 0; layer3 = 0;
                            break;
                    }
                for( int i = 0; i <=7; i++){chip.write(PORT_A, c[i]); //A loop
                Thread::wait(100);}
                chip.write(PORT_A, 0x00);
                for( int i = 0; i <=7; i++){chip.write(PORT_B, c[i]); //A loop
                Thread::wait(100);}
                chip.write(PORT_B, 0x00); //CLEAR
                }
                break;
        }
    Thread::wait(25);    
    }
}    

/* Queue command thread*/
void command_queue_thread(void const *args) {
    while(1) {
        if (rcv_tail < rcv_head) {
            if (rcv[rcv_tail] == 'Z') {
                /* Loop until valid value found */
                while (rcv[(rcv_tail + 1) % RCV_BUF_SIZE] == '\0') {
                    Thread::wait(100);    
                }
                char let = rcv[(rcv_tail + 1) % RCV_BUF_SIZE];
                //pc.printf("\nhere ");
//                pc.putc(let);
//                pc.printf(" here\n");
                command_queue[queue_head] = let;
                queue_head = (queue_head + 1) % COM_BUF_SIZE;   
            }
            rcv[rcv_tail] = '\0'; /* Clear value */
            rcv_tail = (rcv_tail + 1) % RCV_BUF_SIZE;
        }
        Thread::wait(10);
    }
}

/* PC receive interrupt routine */
void pc_recv() {
    led1 = 1;
    while(pc.readable()) {
        /* Print out to ESP8266 hardware */
        esp.putc(pc.getc());
    }
    led1 = 0;
}

/* ESP83266 receive interrupt routine */
void dev_recv() {
    led4 = 1;
    while(esp.readable()) {
        char let = esp.getc();
        /* Echo to pc to see output */
//        pc.putc(let);
        /* Put in receive buffer */
        rcv[rcv_head] = let;
//        pc.putc(rcv[rcv_head]);
        rcv_head = (rcv_head + 1) % RCV_BUF_SIZE;
    }
    led4 = 0;
}


int main() {
    /* Set pc serial baud rate */
    pc.baud(9600);

    /* Set up esp */
    esp.reset();
    esp.baud(9600);
    pc.printf("----SETTING UP CUBE----\r\n");
    esp.setup();
    Thread::wait(1000);
    
    /* Initialize command buffer */
    command_queue = (char*) calloc(sizeof(char), COM_BUF_SIZE);
    
    /* Attach interrupts */
    pc.attach(&pc_recv, Serial::RxIrq);
    esp.attach(&dev_recv, Serial::RxIrq);
    
    /* Print IP and MAC */
    pc.printf("----GET IP---\r\n");
    esp.getIP();
    esp.getMAC();
    
    Thread t1(LED_Thread);
    Thread t2(command_queue_thread);
    pc.printf("\n+++++++++++++READY+++++++++++++\r\n\n");
    while (1) {
        //Prepare for burst mode on all ADC pins and set up interrupt handler
        adc.append(sample_ADC);
        adc.startmode(0,0);
        adc.burst(1);
        adc.setup(p19,1);
        wait(.4);
        adc.interrupt_state(p19,1);
        wait(0.1);
        adc.interrupt_state(p19,0);
        adc.setup(p19,0);
        int actual_rate = adc.actual_sample_rate();
    }
}





