#ifndef _PIXY_H
#define _PIXY_H

#include "TPixy.h"
#include "TPixyInterface.h"

#define X_CENTER        ((PIXY_MAX_X-PIXY_MIN_X)/2)
#define Y_CENTER        ((PIXY_MAX_Y-PIXY_MIN_Y)/2)

class PixySPI : public TPixy<PixyInterfaceSPI>
{
public:
    /** Constructor for the PixySPI class
      * Instantiates a Pixy object that communicates via an SPI connection
      * @param SPI* spi the pointer to the SPI connection
      * @param Serial* serialOut the optional serial output pointer to print out Pixy camera data
      * @param int arg an optional integer argument used for custom implementations of the Pixy library
      */
    PixySPI(SPI* spi, Serial* serialOut = NULL, uint16_t arg = PIXY_DEFAULT_ARGVAL) :
        TPixy<PixyInterfaceSPI>((new PixyInterfaceSPI(spi)), serialOut, arg) {}
};

class ServoLoop
{
public:
    /** Constructor for a ServoLoop object
      * Creates a ServoLoop object for easy control of the Pixy servos
      * @param pgain the proportional gain for the control
      * @param dgain the derivative gain for the control
      */
    ServoLoop(int32_t pgain, int32_t dgain);
    /** Update method for a ServoLoop object
      * Updates the m_pos variable for setting a Pixy servo
      * @param error the error between the center of the camera and the position of the tracking color
      */
    void update(int32_t error);

    int32_t m_pos;
    int32_t m_prevError;
    int32_t m_pgain;
    int32_t m_dgain;
};
#endif