#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
 
SPI spi(p11, p12, p13); // mosi(out), miso(in), sclk(clock)
DigitalOut cs(p14); // cs (the chip select signal)
Serial pc(USBTX, USBRX); // tx, rx ( the usb serial communication )

SDFileSystem sd(p5, p6, p7, p8, "sd");
PwmOut PWMout(p21);
AnalogOut DACout(p18);
AnalogIn fsr(p15);
wave_player waver(&DACout,&PWMout);
FILE *wave_file;
 
int main() {
    // Setup the spi for 7 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(7,0);
    spi.frequency(1000000);
    
    // Set PWMout period
    PWMout.period(1.0/400000.0);
 
    // notify the user that we are starting with the ADC communication
    pc.printf("Starting ADC interaction\n\n\n");
    
    // lets just do this forever
    while (1) {
 
        for (int i = 0 ; i < 2; i++){
            // Select the device by seting chip select low
            cs = 0;
            
            // sending the 6 bits + 1 bit to ignore the null bit
            // coming from the device, so the data that is sent is 1100000
            spi.write(0x60 + (i*4));
            
            // now the device sends back the readings 12 bits, 7 bits at a time
            uint8_t high = spi.write(0x00);
            uint8_t low = spi.write(0x00);
     
            // shift out the right bits
            low = ( high << 5 ) | (low >> 2);
            high = high >> 3;
            
            // shift and or the result together
            int value = ( high << 8 ) | low;
            
            // and voila we have the value and we can print it for the user
            //pc.printf("sensor %d value = %u\n", i, value);
            switch (i){
                case 0:
                    if (value > 200) {
                        pc.printf("\tX\r");
                        wave_file=fopen("/sd/highhat.wav","r");
                        waver.play(wave_file);
                        fclose(wave_file);
                    }
                    break;
                case 1:
                    if (value > 200){
                        pc.printf("\t\t\t\tX\r");
                        wave_file=fopen("/sd/snare.wav","r");
                        waver.play(wave_file);
                        fclose(wave_file);
                    }
                    break;
            }
            
            // Deselect the device
            cs = 1;
        }
 
        // delay some time before reading again
        wait_us(100);
    }
}