/*
** File name:            Thread.cpp
** Descriptions:        Creates multiple thread instances of the same function
**
**------------------------------------------------------------------------------------------------------
** Created by:            Ivan Shindev
** Created date:        06/29/2013
** Version:                1.0
** Descriptions:        The original version
**
**------------------------------------------------------------------------------------------------------
** Modified by:            
** Modified date:    
** Version:
** Descriptions:        
********************************************************************************************************/
#include "Threads.h"

/*Initialize memory and set the pointer to the thread*/
int initThread(ThreadList **addresOfTL,os_pthread pthread,ThreadList** addresOfThread,int max)
{
    
    if(*addresOfTL==NULL)
    {
        if(max<=0)
            return 0;
        *addresOfTL=(ThreadList*)malloc(sizeof(ThreadList));
        if(*addresOfTL==NULL)
            return 0;
        
        (*addresOfTL)->thread=NULL;
        (*addresOfTL)->thread=(osThreadDef_t *)malloc(sizeof(osThreadDef_t ));
    
        if((*addresOfTL)->thread==NULL)
            return 0;
        
        (*addresOfTL)->thread->pthread=pthread;
        (*addresOfTL)->thread->tpriority=osPriorityNormal;
        (*addresOfTL)->thread->stacksize=DEFAULT_STACK_SIZE;
    
        (*addresOfTL)->thread->stack_pointer=NULL;
        (*addresOfTL)->thread->stack_pointer=(unsigned char *)malloc(DEFAULT_STACK_SIZE);
    
        if((*addresOfTL)->thread->stack_pointer==NULL)
            return 0;
        (*addresOfTL)->nextThread=NULL;
        (*addresOfThread)=(*addresOfTL);
        return 1;
    }
    else
    {
        if((*addresOfTL)->thread->tcb.state == 0)
        {
            free((*addresOfTL)->thread->stack_pointer);
            (*addresOfTL)->thread->stack_pointer=NULL;
            free((*addresOfTL)->thread);
            (*addresOfTL)->thread=NULL;
            (*addresOfTL)->thread=(osThreadDef_t *)malloc(sizeof(osThreadDef_t ));
    
            if((*addresOfTL)->thread==NULL)
                return 0;
        
            (*addresOfTL)->thread->pthread=pthread;
            (*addresOfTL)->thread->tpriority=osPriorityNormal;
            (*addresOfTL)->thread->stacksize=DEFAULT_STACK_SIZE;
    
            (*addresOfTL)->thread->stack_pointer=NULL;
            (*addresOfTL)->thread->stack_pointer=(unsigned char *)malloc(DEFAULT_STACK_SIZE);
    
            if((*addresOfTL)->thread->stack_pointer==NULL)
                return 0;
            (*addresOfThread)=(*addresOfTL);
            return 1;
        }
        else
            return initThread(&((*addresOfTL)->nextThread),pthread,addresOfThread,--max);
    }
}

