/*
** File name:            Debug.h
** Descriptions:         TCP Server that sends debug messages to a connected client
**
**------------------------------------------------------------------------------------------------------
** Created by:            Ivan Shindev
** Created date:        06/11/2013
** Version:                1.0
** Descriptions:        The original version
** 
**------------------------------------------------------------------------------------------------------
** Modified by:            
** Modified date:    
** Version:
** Descriptions:        
********************************************************************************************************/
/* How to use the library
Include Debug.h in any file that sends debugging messages 

Start the debugging server in the main 
    initDebug(); //initialize Debug server
    startDebug(debug_port);  //start the Debug server 
    while(!isDebugConnected()) //do nothing until a debug client is connected (optional)
    {
  
    }
    
Send a debugging message to the connected client using sendDebugMessage(char *message)
    Example: sendDebugMessage("Initialization failed");


*/
#include "EthernetInterface.h"
#include "mbed.h"

#ifndef __DEBUG_H 
#define __DEBUG_H


/* connectDebug(void const *port) is the main Debug server Thread

*/
void connectDebug(void const *port);

/* sendDebugMessage(char *message) sends a message to the connected client

*/
void sendDebugMessage(char *message);

/* startDebug(int port) starts the debugging server in a new Thread

*/
void startDebug(int port);

/* initDebug() initializes the _debug_connected variable 

*/
void initDebug();


int isDebugConnected();
#endif 
