/*
** File name:            Debug.cpp
** Descriptions:         TCP Server that sends debug messages to a connected client
**
**------------------------------------------------------------------------------------------------------
** Created by:            Ivan Shindev
** Created date:        06/11/2013
** Version:                1.0
** Descriptions:        The original version
**
**------------------------------------------------------------------------------------------------------
** Modified by:            
** Modified date:    
** Version:
** Descriptions:        
********************************************************************************************************/
/* How to use the library
Include Debug.h in any file that sends debugging messages 

Start the debugging server in the main 
    initDebug(); //initialize Debug server
    startDebug(debug_port);  //start the Debug server 
    while(!isDebugConnected()) //do nothing until a debug client is connected (optional)
    {
  
    }
    
Send a debugging message to the connected client using sendDebugMessage(char *message)
    Example: sendDebugMessage("Initialization failed");


*/

#include "Debug.h"
#include "mbed.h"

int _debug_socket;
int _debug_connected;
Mutex debug_mutex;
/* sendDebugMessage(char *message) sends a message to the connected client

*/
void sendDebugMessage(char *message)
{
    
    lwip_send(_debug_socket ,message,strlen(message)*sizeof(char),0);
}

/* connectDebug(void const *port) is the main Debug server Thread

*/
void connectDebug(void const *port)
{
     int _port=(int) port;
     int socket_server;
    struct sockaddr_in localHost;
    memset(&localHost, 0, sizeof(localHost));
    
    if( (socket_server= lwip_socket(AF_INET, SOCK_STREAM, 0))<0)
    {
      //  return -1;
    }
    localHost.sin_family = AF_INET;
    localHost.sin_port = htons(_port); //port
    localHost.sin_addr.s_addr = INADDR_ANY;  //localhost address
    
    if (lwip_bind(socket_server, (const struct sockaddr *) &localHost, sizeof(localHost)) < 0) {
 
       // return -1;
    }
    if (lwip_listen(socket_server,5)<0)
    {

        perror("listen");
        exit(EXIT_FAILURE);
    }
  
    socklen_t newSockRemoteHostLen = sizeof(localHost);
   
    while(1)
    {
        int nn = lwip_accept(socket_server, (struct sockaddr*) &localHost, &newSockRemoteHostLen);
        debug_mutex.lock();
            _debug_connected=1;
        debug_mutex.unlock();
        _debug_socket=nn;
        sendDebugMessage("You are now connected to Debug Server");

         
    
   }
}

osThreadDef(connectDebug, osPriorityNormal, DEFAULT_STACK_SIZE);

/* startDebug(int port) starts the debugging server in a new Thread

*/
void startDebug(int port)
{
     osThreadCreate(osThread(connectDebug), (void *) port);
}



/* initDebug() initializes the _debug_connected variable 

*/
void initDebug()
{
    debug_mutex.lock();
       _debug_connected=0;
    debug_mutex.unlock();
}

/* isDebugConnected() returns 1 if a debug client is connected

*/
int isDebugConnected()
{
    int temp;
    debug_mutex.lock();
       temp=_debug_connected;
    debug_mutex.unlock();
    return temp;
}
