#include "mbed.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"
Serial pc(USBTX, USBRX); // tx, rx
Serial device(p9, p10);  // tx, rx
PinName cts=p11;//CTS
PinName rts=p12;//RTS

DigitalOut _TX(LED1);//TX access lamp
DigitalOut _RX(LED2);//RX access lamp

void pc_rx ()
{
    _TX=1;
    int buff=pc.getc();
    switch(buff) {
        case 'H':
            device.printf("Hello World!");
            break;
        default:
            device.putc(buff);
            break;
    }
    _TX=0;
}
void dev_rx ()
{
    _RX=1;
    pc.putc(device.getc());
    _RX=0;
}
int main()
{
    pc.baud(230400);
    device.baud(115200);
    device.set_flow_control(Serial::RTSCTS,rts,cts);

    pc.attach(&pc_rx,Serial::RxIrq);
    device.attach(&dev_rx,Serial::RxIrq);
    PHY_PowerDown();
    while(1) {
        sleep();
    };
}