#ifndef MBED_SPI
#define MBED_SPI
#include "mbed.h"
#include "L3GD20_Resister.h"
typedef struct {
    int16_t X;
    int16_t Y;
    int16_t Z;
    float x;
    float y;
    float z;
} anglerrates;
class L3GD20
{
public:
    L3GD20(PinName miso, PinName mosi, PinName scl, PinName cs/*, PinName interrupt1=NC, PinName interrupt2=NC*/);
    typedef enum {
        null=0x00
        ,WhoAmI=0x0F
        ,CtrlReg1=0x20
        ,CtrlReg2=0x21
        ,CtrlReg3=0x22
        ,CtrlReg4=0x23
        ,CtrlReg5=0x24
        ,Reference=0x25
        ,OutTemp=0x26
        ,StatusReg=0x27
        ,OutXL=0x28
        ,OutXH=0x29
        ,OutYL=0x2A
        ,OutYH=0x2B
        ,OutZL=0x2C
        ,OutZH=0x2D
        ,FIFOCtrlReg=0x2E
        ,FIFOSrcReg=0x2F
        ,INT1Cfg=0x30
        ,INT1Src=0x31
        ,INT1ThsXH=0x32
        ,INT1ThsXL=0x33
        ,INT1ThsYH=0x34
        ,INT1ThsYL=0x35
        ,INT1ThsZH=0x36
        ,INT1ThsZL=0x37
        ,INT1Duration=0x38
        ,READ=0x80
    } RESISTER;
    typedef enum {
        Y=0x1
        ,X=0x1<<1
        ,Z=0x1<<2
        ,XY=X|Y
        ,XZ=X|Z
        ,YZ=Y|Z
        ,XYZ=X|Y|Z
    } DIRECTION;


    void start(DIRECTION enable);
    void stop();
    void sleep();
    void read(anglerrates* val,DIRECTION direction);
    int readTemperature();
    typedef enum {
        BYPASSmode=0x0
        ,FIFOmode
        ,STREAMmode
        ,STREAMtoFIFOmode
        ,BYPASStoSTREAMmode
    } FIFO_mode;
    typedef enum {
        none=0
        ,empty
        ,watermark
        ,overrun
    } FIFOstatus;
    struct tagFIFO {
        FIFOstatus status;
        int level;
    } FIFO;
    void enableFIFO(FIFO_mode mode,FIFOstatus interrupt,const int threshold);
    void updateFIFO(void);
    struct config {
        //read and write resister
        union CTRL_REG1 CTRL_REG1;
        union CTRL_REG2 CTRL_REG2;
        union CTRL_REG3 CTRL_REG3;
        union CTRL_REG4 CTRL_REG4;
        union CTRL_REG5 CTRL_REG5;
        union REF_DATACAP REF_DATACAP;
        union OUT_TEMP OUT_TEMP;
        union STATUS_REG STATUS_REG;
        union FIFO_CTRL_REG FIFO_CTRL_REG;
        union INT1_CFG INT1_CFG;
        union INT1_TSH_XH INT1_TSH_XH;
        union INT1_TSH_XL INT1_TSH_XL;
        union INT1_TSH_YH INT1_TSH_YH;
        union INT1_TSH_YL INT1_TSH_YL;
        union INT1_TSH_ZH INT1_TSH_ZH;
        union INT1_TSH_ZL INT1_TSH_ZL;
        union INT1_DURATION INT1_DURATION;
    } _config;
    struct status {
        //read only resister
        int OUT_TEMP;
        int STATUS_REG;
        union FIFO_SRC_REG FIFO_SRC_REG;
        int INT1_SRC;
    } _status;
    void configReadOut(void);
    void statusReadOut(void);
protected:
    void write(RESISTER reg,int val);
    void read(RESISTER reg,int* val);
    /*
        void datarate(uint8_t rate,uint8_t bandwidth);
        void setDataFormat();
        void filter(uint8_t mode,uint8_t frequency);
        void channelSource(uint8_t channnel,uint8_t dataSelection,uint8_t interruptSelection);
        void FIFO(uint8_t mode,uint8_t watermark);
        void interrupt(uint8_t source,uint8_t threthold,uint8_t duration,uint8_t Wait);
    */
    SPI _spi;
    DigitalOut _cs;
};

#endif