#ifndef L3GD20_RESISTER_MAP
#define L3GD20_RESISTER_MAP

union CTRL_REG1 {
    int word;
    uint8_t byte;
    struct {
        unsigned Yen:1;
        unsigned Xen:1;
        unsigned Zen:1;
        unsigned PD:1;
        unsigned BW0:1;
        unsigned BW1:1;
        unsigned DR0:1;
        unsigned DR1:1;
    } b;
    struct {
        unsigned Enable:3;
        unsigned PD:1;
        unsigned BW:2;
        unsigned DR:2;
    } B;
};
union CTRL_REG2 {
    int word;
    uint8_t byte;
    struct {
        unsigned HPCF0:1;
        unsigned HPCF1:1;
        unsigned HPCF2:1;
        unsigned HPCF3:1;
        unsigned HPM0:1;
        unsigned HPM1:1;
        unsigned :2;
    } b;
    struct {
        unsigned HPCF:4;
        unsigned HPM:2;
        unsigned none:2;
    } B;
};
union CTRL_REG3 {
    int word;
    uint8_t byte;
    struct {
        unsigned I2_Empty:1;
        unsigned I2_ORun:1;
        unsigned I2_WTM:1;
        unsigned I2_DRDY:1;
        unsigned PP_OD:1;
        unsigned H_Lactive:1;
        unsigned I1_Boot:1;
        unsigned I1_Int1:1;
    } b;
};
union CTRL_REG4 {
    int word;
    uint8_t byte;
    struct {
        unsigned SIM:1;
        unsigned none:2;
        unsigned nil:1;
        unsigned FS0:1;
        unsigned FS1:1;
        unsigned BLE:1;
        unsigned BDU:1;
    } b;
    struct {
        unsigned SIM:1;
        unsigned none:2;
        unsigned nil:1;
        unsigned FS:2;
        unsigned BLE:1;
        unsigned BDU:1;
    } B;
};
union CTRL_REG5 {
    int word;
    uint8_t byte;
    struct {
        unsigned Out_Sel0:1;
        unsigned Out_Sel1:1;
        unsigned INT_Sel0:1;
        unsigned INT_Sel1:1;
        unsigned HPen:1;
        unsigned nil:1;
        unsigned FIFO_EN:1;
        unsigned BOOT:1;
    } b;
    struct {
        unsigned Out_Sel:2;
        unsigned INT_Sel:2;
        unsigned HPen:1;
        unsigned nil:1;
        unsigned FIFO_EN:1;
        unsigned BOOT:1;
    } B;
};
union REF_DATACAP {
    int word;
    uint8_t byte;
    struct {
        unsigned Ref0:1;
        unsigned Ref1:1;
        unsigned Ref2:1;
        unsigned Ref3:1;
        unsigned Ref4:1;
        unsigned Ref5:1;
        unsigned Ref6:1;
        unsigned Ref7:1;
    } b;
    struct {
        unsigned Ref:8;
    } B;
};
union OUT_TEMP {
    int word;
    uint8_t byte;
    struct {
        unsigned Temp0:1;
        unsigned Temp1:1;
        unsigned Temp2:1;
        unsigned Temp3:1;
        unsigned Temp4:1;
        unsigned Temp5:1;
        unsigned Temp6:1;
        unsigned Temp7:1;
    } b;
    struct {
        unsigned Temp:8;
    } B;
};
union STATUS_REG {
    int word;
    uint8_t byte;
    struct {
        unsigned XDA:1;
        unsigned YDA:1;
        unsigned ZDA:1;
        unsigned ZYXDA:1;
        unsigned XOR:1;
        unsigned YOR:1;
        unsigned ZOR:1;
        unsigned XYZOR:1;
    } b;
};
union FIFO_CTRL_REG {
    int word;
    uint8_t byte;
    struct {
        unsigned WTM0:1;
        unsigned WTM1:1;
        unsigned WTM2:1;
        unsigned WTM3:1;
        unsigned WTM4:1;
        unsigned FM0:1;
        unsigned FM1:1;
        unsigned FM2:1;
    } b;
    struct {
        unsigned WTM:5;
        unsigned FM:3;
    } B;
};
union FIFO_SRC_REG {
    int word;
    uint8_t byte;
    struct {
        unsigned FSS0:1;
        unsigned FSS1:1;
        unsigned FSS2:1;
        unsigned FSS3:1;
        unsigned FSS4:1;
        unsigned EMPTY:1;
        unsigned OVR:1;
        unsigned WTM:1;
    } b;
    struct {
        unsigned FSS:5;
        unsigned EMPTY:1;
        unsigned OVR:1;
        unsigned WTM:1;
    } B;
};
union INT1_CFG {
    int word;
    uint8_t byte;
    struct {
        unsigned XLIE:1;
        unsigned XHIE:1;
        unsigned YLIE:1;
        unsigned YHIE:1;
        unsigned ZLIE:1;
        unsigned ZHIE:1;
        unsigned LIR:1;
        unsigned ANDOR:1;
    } b;
};
union INT1_TSH_XH {
    int word;
    uint8_t byte;
    struct {
        unsigned THSX8:1;
        unsigned THSX9:1;
        unsigned THSX10:1;
        unsigned THSX11:1;
        unsigned THSX12:1;
        unsigned THSX13:1;
        unsigned THSX14:1;
        unsigned nil:1;
    } b;
    struct {
        unsigned THSH:7;
    } B;
};
union INT1_TSH_XL {
    int word;
    uint8_t byte;
    struct {
        unsigned THSX0:1;
        unsigned THSX1:1;
        unsigned THSX2:1;
        unsigned THSX3:1;
        unsigned THSX4:1;
        unsigned THSX5:1;
        unsigned THSX6:1;
        unsigned THSX7:1;
    } b;
    struct {
        unsigned THSL:7;
    } B;
};
union INT1_TSH_YH {
    int word;
    uint8_t byte;
    struct {
        unsigned THSY8:1;
        unsigned THSY9:1;
        unsigned THSY10:1;
        unsigned THSY11:1;
        unsigned THSY12:1;
        unsigned THSY13:1;
        unsigned THSY14:1;
        unsigned nil:1;
    } b;
    struct {
        unsigned THSH:7;
    } B;
};
union INT1_TSH_YL {
    int word;
    uint8_t byte;
    struct {
        unsigned THSY0:1;
        unsigned THSY1:1;
        unsigned THSY2:1;
        unsigned THSY3:1;
        unsigned THSY4:1;
        unsigned THSY5:1;
        unsigned THSY6:1;
        unsigned THSY7:1;
    } b;
    struct {
        unsigned THSL:7;
    } B;
};
union INT1_TSH_ZH {
    int word;
    uint8_t byte;
    struct {
        unsigned THSZ8:1;
        unsigned THSZ9:1;
        unsigned THSZ10:1;
        unsigned THSZ11:1;
        unsigned THSZ12:1;
        unsigned THSZ13:1;
        unsigned THSZ14:1;
        unsigned nil:1;
    } b;
    struct {
        unsigned THSH:7;
    } B;
};
union INT1_TSH_ZL {
    int word;
    uint8_t byte;
    struct {
        unsigned THSZ0:1;
        unsigned THSZ1:1;
        unsigned THSZ2:1;
        unsigned THSZ3:1;
        unsigned THSZ4:1;
        unsigned THSZ5:1;
        unsigned THSZ6:1;
        unsigned THSZ7:1;
    } b;
    struct {
        unsigned THSL:7;
    } B;
};
union INT1_DURATION {
    int word;
    uint8_t byte;
    struct {
        unsigned D0:1;
        unsigned D1:1;
        unsigned D2:1;
        unsigned D3:1;
        unsigned D4:1;
        unsigned D5:1;
        unsigned D6:1;
        unsigned WAIT:1;
    } b;
    struct {
        unsigned D:6;
        unsigned WAIT:1;
    } B;
};
/*
#define L3GD20_READ 0x80
#define L3GD20_WHO_AM_I      0x0F
#define L3GD20_CTRL_REG1     0x20
#define L3GD20_CTRL_REG2     0x21
#define L3GD20_CTRL_REG3     0x22
#define L3GD20_CTRL_REG4     0x23
#define L3GD20_CTRL_REG5     0x24
#define L3GD20_REFERENCE     0x25
#define L3GD20_OUT_TEMP      0x26
#define L3GD20_STATUS_REG    0x27
#define L3GD20_OUT_X_L       0x28
#define L3GD20_OUT_X_H       0x29
#define L3GD20_OUT_Y_L       0x2A
#define L3GD20_OUT_Y_H       0x2B
#define L3GD20_OUT_Z_L       0x2C
#define L3GD20_OUT_Z_H       0x2D
#define L3GD20_FIFO_CTRL_REG 0x2E
#define L3GD20_FIFO_SRC_REG  0x2F
#define L3GD20_INT1_CFG      0x30
#define L3GD20_INT1_SRC      0x31
#define L3GD20_INT1_THS_XH   0x32
#define L3GD20_INT1_THS_XL   0x33
#define L3GD20_INT1_THS_YH   0x34
#define L3GD20_INT1_THS_YL   0x35
#define L3GD20_INT1_THS_ZH   0x36
#define L3GD20_INT1_THS_ZL   0x37
#define L3GD20_INT1_DURATION 0x38
*/

#endif