#include "mbed.h"
#include "IRremote.h"
#include "debug.h"
IRremote::IRremote(PinName trans,PinName receive,int* point,int length,Serial* device)
    :_trans(trans)
    ,_receive(receive)
{
    _device=device;
    _point=point;
    _length=length;
    _trans.period_us(26);
    _trans.pulsewidth_us(13);
}
void IRremote::setArray(int* point,int length)
{
    _point=point;
    _length=length;
}
void IRremote::showArray()
{
    for(int i=0; i<_length; i++) {
        if(_point[i]==0)break;
        log_info("%03d:%d\r\n",i,_point[i]);
    }
}
int IRremote::sum(void)
{
    if(_length!=0) {
        if(_sum==0) {
            for(int i=0; i<_length; i++) {
                _sum += _point[i];
            }
        }
        return _sum;
    } else {
        return -1;
    }
}
float IRremote::average(void)
{
    if(_length!=0) {
        if(_sum==0) {
            for(int i=0; i<_length; i++) {
                _sum += _point[i];
            }
        }
        if(_ave==0.0) {
            _ave=(float)_sum/(float)_length;
        }
        return _ave;
    } else {
        return -1.0;
    }
}
void IRremote::trans(void (*afunc)(void),void (*bfunc)(void))
{
    afunc();
    _timer.start();
    _trans = 0;
    if (_point[0] == 0) {
        _timer.stop();
        _trans=0;
        return;
    }
    for (int i = 0; i < _length; i++) {
        if (_point[i] == 0) {
            _timer.stop();
            _trans=0.0f;
            bfunc();
            break;
        }
        if (i&1) { //odd
            _timer.reset();
            while (_timer.read_us() <= _point[i]) {
                _trans=0.0f;
            }
        } else { //even
            _timer.reset();
            while (_timer.read_us() <= _point[i]) {
                _trans=0.5f;
            }
        }
    }
    _timer.stop();
    _trans=0;
}
void IRremote::receive(void (*afunc)(void),void (*bfunc)(void))
{
    afunc();
    for (int i = 0; i < _length; i++) {
        _point[i] = 0;
    }
    int lastStatus=0;
    log_info("Common!\r\n");
    _timer.start();
    _timer.reset();
    while (_receive) {
        if (_timer.read_us()>=5000000) {
            _timer.stop();
            log_info("TimeOut..\r\n");
            return;
        }
    }
    _timer.reset();
    for (int i =0; i < _length; i++) {
        while (lastStatus == _receive) {
            if (_timer.read_us()>=1000000) {
                log_info("less than %d..Done!\r\n",_length);
                _timer.stop();
                bfunc();
                return;
            }
        }
        _point[i] = _timer.read_us();
        lastStatus = !lastStatus;
        _timer.reset();
    }
    log_info("over %d...\r\n",_length);
}

void IRremote::init(void)
{
    _length=0;
}
