#ifndef MBED_IRREMOTE_H
#define MBED_IRREMOTE_H
#include "mbed.h"
#include "debug.h"

class IRremote
{
public:
    IRremote(PinName trans,PinName receive,int* point,int length,Serial* device);
    void setArray(int* point,int length);
    void showArray();
    int sum();
    float average();
    int datalength();
    void trans(void (*afunc)(void),void (*bfunc)(void));
    void receive(void (*afunc)(void),void (*bfunc)(void));
protected:
    void init();
    int* _point;
    int _length;
    int _sum;
    float _ave;
    PwmOut _trans;
    DigitalIn _receive;
    Timer _timer;
    Serial* _device;
    struct {
        unsigned lastStatus : 1;
    } flag;
};

#endif