#include "mbed.h"

// Test app to cause program to suddently terminate when using serial interrupt...
// Line 24 seems to be the important bit, but I don't really understand why?
// Is it perhaps the putc is peroperly clearing the interrupt flag instead of the getc?


// usb serial device defaults to 9600 baud, 8N1 on /dev/ttyACM0 (in Linux!)
Serial pc(USBTX, USBRX); // tx, rx

// debugging LEDs
DigitalOut interrupt(LED1);
DigitalOut tx(LED4);

// one byte receive buffer
char rx_byte;

void handle()
{
  interrupt = 1;
  //if(pc.readable()) // <--- this line doesn't matter either way...
  {
    rx_byte = pc.getc();
    //pc.putc(rx_byte);  // <--- WITHOUT THIS LINE, THE APPLICATION WILL HANG IF IT RECEIVES WHILE SENDING!
  }
  interrupt = 0;
  return;
}

int main()
{
  interrupt = 0;
  tx = 0;
  pc.attach(handle);
  
  while(1) 
  {
    // send a long string of bytes 
    tx = 1;
    for(int i=0;i<20;i++)
    {
      pc.printf("If I receive while transmitting this I will crash...\r\n");
    }
    tx = 0;
    
    wait(1.0);
  }
}