#include "mbed.h"
#include "WifiPlusClick.h"
#include "TCPSocketServer.h"

//#define WPA2_PASSWORD

#ifndef WPA2_PASSWORD


//  Please note that when using this binary passphrase a connection can be made much faster.
static const char passphrase[32] = {
    0xac, 0x4d, 0x41, 0x29, 0xa4, 0xd8, 0xfd, 0x15, 
    0xaf, 0x29, 0xd7, 0x8d, 0xb2, 0x50, 0x3c, 0xd9, 
    0xa7, 0x4f, 0x5e, 0x64, 0x5d, 0x82, 0x01, 0x76,
    0x1d, 0x7f, 0xda, 0xdc, 0x43, 0xcd, 0xa0, 0xd8};
static const WPA_SECURITY_t sec = WPA_OR_WPA2_PSK;
static const char ssid[] = "<your ssid>";
#else
//  Please note that it will take approximately 30 seconds if using an ascii password because the module has to calculate the binary password before making the actual connection
static char passphrase[] = "<Password>";
static WPA_SECURITY_t sec = WPA_OR_WPA2_PASSPHRASE;
static const char ssid[] = "<your ssid>";
#endif




Serial pc(USBTX, USBRX, "pc");


const char *response = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nServer: mbed embedded\r\n\n\r<HTML><HEAD><META content=\"text/html\" http-equiv=Content-Type></HEAD><BODY><h1>Strike</h1><P>It just works !<P></BODY></HTML>\r\n\r\n";


int main() {

    WifiPlusClick   wifi(p13, p14, p21, true, ssid, sec, passphrase, 32);
        
    pc.baud(460800);                            //  WARNING : I am using a higher baud rate !!!! You may need to adjust your telnet connection !!!
    pc.printf("Good day !\n");

    if (wifi.connect() ) {
        wait(0.2);

        pc.printf("Trying to setup a server socket !\n\n");
        TCPSocketServer svr;
        
        svr.set_blocking(true, 60000);
        pc.printf("Trying to bind to port 80 !\n\n");
        if (svr.bind(80) == 0) {
            pc.printf("Successfully bound to port 80 !\n\n");

            if (svr.listen(1) == 0) {
                pc.printf("Successfully listening !\n\n");
                TCPSocketConnection client;
                if (svr.accept(client) == 0) {
                    pc.printf("Successfully received incoming connection !\n\n");
                    
                    client.send_all((char*)response, strlen(response));
                    svr.close();
                } else {
                    pc.printf("Failed to serve incoming connections !\n\n");
                }
            } else {
                pc.printf("Failed to listen !\n\n");
            }
        } else {
            pc.printf("Failed to bind to port 80 !\n\n");
        }
    }
}
