#ifndef __DEBUG_H__
#define __DEBUG_H__


#ifdef DEBUG
#define INFO(x, ...) std::printf("[INFO: %s:%d]"x"\r\n", __FILE__, __LINE__, ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[WARN: %s:%d]"x"\r\n", __FILE__, __LINE__, ##__VA_ARGS__);
#else
#define INFO(x, ...)
#define WARN(x, ...)
//#define ERR(x, ...)
#endif
#define ERR(x, ...) std::printf("[ERR: %s:%d]"x"\r\n", __FILE__, __LINE__, ##__VA_ARGS__);


#ifdef ENABLE_STACK_CHECK
#define BEGIN_STACK_CHECK()     char _stack_check; _stack_check = 0xA5
#define RETURN_STACK_CHECK(x)   if (_stack_check != 0xA5){ error("STACK CHECK"); while(1); } return (x)
#define END_STACK_CHECK()       if (_stack_check != 0xA5){ error("STACK CHECK"); while(1); } return
#else
#define BEGIN_STACK_CHECK()
#define RETURN_STACK_CHECK(x)   return (x)
#define END_STACK_CHECK()       return
#endif


#endif //   __DEBUG_H__