#include "mbed.h"
#include "WifiPlusClick.h"



WifiPlusClick::WifiPlusClick(PinName tx, PinName rx, PinName rst, bool dhcp, const char * ssid, WPA_SECURITY_t sec, const char* passphrase, int plen)
    : Wifi(tx, rx, rst)
{
    char ChannelList[11] = {1,2,5,6,7,8,9,10,11, 12, 13};
    Reset();
    wait(.8);

    //   Set to european domain  
    SetRegionalDomain(ETSI);
    SetChannelList(5, ChannelList);
    SetARPTime(1);
    SetRetryCount(20,20);
    
    SetSSID(1, ssid);
    SetSecurityWPA(1, sec, plen, passphrase);
}

bool WifiPlusClick::connect()
{
    SetNetworkMode(1, INFRASTRUCTURE);
    SetIpAddress(true, NULL);
    
    Connect(1);
    
    return AwaitConnected(60);
}

bool WifiPlusClick::connect(IPADDRESS_t *ipAddress, IPADDRESS_t *subnetMask, IPADDRESS_t *ipGateway)
{
    if ((ipAddress == NULL) || (subnetMask == NULL) || (ipGateway == NULL))
        return false;
        
    SetNetworkMode(1, ADHOC);
    SetIpAddress(false, ipAddress);
    SetSubnetMask(subnetMask);
    SetGatewayIpAddress(ipGateway);
    
    Connect(1);
    
    return AwaitConnected(60); 
}

bool WifiPlusClick::disconnect()
{
    Disconnect();
    
    return AwaitDisconnected(60);
}