/* Copyright (c) 2013 Henry Leinen (henry[dot]leinen [at] online [dot] de)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "TCPSocketServer.h"

TCPSocketServer::TCPSocketServer() 
{
}


int TCPSocketServer::bind(int port)
{
    _socket = Wifi::getInstance()->SocketCreate(TCP);
    
    if (_socket == InvalidSocketHandle) {
        return -1;
    }
        
    if (!Wifi::getInstance()->SocketBind(_socket, port)) {
        Wifi::getInstance()->SocketClose(_socket);
        return -1;
    }
    
    return 0;
}

int TCPSocketServer::listen(int backlog)
{
    if (_socket == InvalidSocketHandle)
        return -1;
        
    if (!Wifi::getInstance()->SocketListen(_socket, backlog)) {
        Wifi::getInstance()->SocketClose(_socket);
        return -1;
    }
    
    return backlog;
}

int TCPSocketServer::accept(TCPSocketConnection &connection)
{
    if (_socket == InvalidSocketHandle)
        return -1;
        
    if (_blocking) {
        Timer t;
        
        t.start();
        
        while( t.read_ms() < _timeout ) {
            if (Wifi::getInstance()->SocketAccept(_socket, connection._socket, connection._port, connection._ipAddress)) {
                if (connection._socket == InvalidSocketHandle) {
                } else {
                    connection._is_connected = true;
                    return 0;
                }
            } else {
                break;
            }
        }
        
        //  Attempt timed out
        return -1;
    } else {
        //  non blocking, so we just check wheather we are connected
        if (Wifi::getInstance()->SocketAccept(_socket, connection._socket, connection._port, connection._ipAddress)) {
            if (connection._socket == InvalidSocketHandle) {
                connection._is_connected = false;
                return -1;
            } else {
                connection._is_connected = true;
                return 0;
            }
        } else {
            connection._is_connected = false;
            return -1;
        } 
    }
}
