/* Copyright (c) 2013 Henry Leinen (henry[dot]leinen [at] online [dot] de)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "Socket/UDPSocket.h"



UDPSocket::UDPSocket()
{
}

int UDPSocket::init()
{
    _socket = Wifi::getInstance()->SocketCreate(UDP);
    
    if (_socket == InvalidSocketHandle)
        return -1;
    
    return 0;
}

int UDPSocket::bind(unsigned int port)
{
    _socket = Wifi::getInstance()->SocketCreate(UDP);
    
    if (_socket == InvalidSocketHandle)
        return -1;
        
    if (!Wifi::getInstance()->SocketBind(_socket, port)) {
        close();
        return -1;
    }
    
    return 0;
}

int UDPSocket::sendTo(Endpoint &remote, char *packet, int length)
{
    if (_socket == InvalidSocketHandle)
        return -1;
    if (packet == NULL) 
        return -1;
        
    return Wifi::getInstance()->SocketSendTo(_socket, &remote._ipAddress, remote._port, packet, length);
}

int UDPSocket::receiveFrom(Endpoint &remote, char *packet, int length)
{
    if (_socket == InvalidSocketHandle)
        return -1;
    if (packet == NULL)
        return -1;

    return Wifi::getInstance()->SocketRecvFrom(_socket, &remote._ipAddress, &remote._port, packet, length);
}
