/* Copyright (c) 2013 Henry Leinen (henry[dot]leinen [at] online [dot] de)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __TCPSOCKETSERVER_H__
#define __TCPSOCKETSERVER_H__

#include "Socket/Socket.h"
#include "Socket/TCPSocketConnection.h"

/** Class TCPSocketServer inherits from class Socket. Implements the TCP server socket which is used to listen for a new incoming connection.
  * This implementation can have a backlog of up to 8 sockets. Please note that the number of listening sockets depends on how the WifiPlusClick
  * Module has been configured.
  */
class TCPSocketServer : public Socket
{
public:
    /** Public constructor to instantiate an object of TCPSocketServer. */
    TCPSocketServer();
    
    /** Bind function to bind the TCPSocketServer to a specific local port as a precondition to listen to new connection requests.
      * @param port : local port to which the server socket shall be bound.
      * @returns : 0 if successfull, or -1 on failure.
      */
    int bind(int port);
    
    /** Listen function allows a bound socket to listen for incoming connections. The number of connectable socket objects can be specified.
      * @note: the number of sockets is a configurable resource on WifiPlusClick modules. Use the configuration function Wifi::SocketAllocate to
      * specify the number of sockets to allocate.
      * @param backlog : number of sockets which are connectable in the listen state.
      * @returns : the new backlog number, or -1 on failure
      */
    int listen( int backlog = 1 );
    
    /** Accept function will be used on a bound and listening socket. Function will return if a socket connection has been made or a timeout occured.
      * @param connection : A reference to a TCCPSocketConnection object which will be a valid client socket if a connection has been made.
      * @returns : 0 if successfull, or -1 on failure.
      */
    int accept(TCPSocketConnection& connection);
};

#endif //   __TCPSOCKETSERVER_H__