/* Copyright (c) 2013 Henry Leinen (henry[dot]leinen [at] online [dot] de)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __SOCKET_H__
#define __SOCKET_H__


#include "Wifi.h"

/** Class socket is the base class implementation for TCP and UDP sockets. As the socket class does not provide a full implementation of any kind, it is not recommended to use it.
  * Class socket is required to implement the base functionality for UDP and TCP sockets in the WifiPlusClick library implementation.
  * @note Please note that in this implementation the set_option function is not working as the WifiPlusClick module does not support this functionality.
  */
class Socket
{
public:
    /** Constructor of socket object.
      */
    Socket();
    
    /** Function set_blocking sets the socket into a blocking or non-blocking status. In case of a blocking socket a timeout can be specified.
      * @param blocking : set to true if time consuming socket operations shall block execution until they are finished or until a timeout occurs. If set to false, socket operations will terminated immediately.
      * @param timeout  : a timeout value in milliseconds for use in blocking operations.
      */
    void set_blocking(bool blocking, unsigned int timeout = 1500);
    
    /** Function set_option is not working as expected, because there this functionality is not supported by the WifiPlusClick module. 
      * @note This functionality is just kept for compatibility reasons. */
    int set_option(int level, int optname, const void* optval, int socklen);
    
    /** Function close will close the socket.
      * @param shutdown : This parameter will actually be ignored by the implementation.
      * @returns :
      *     -1 if not successfull
      *     >=0 if successfull
      */
    int close( bool shutdown = true );
    
    ~Socket();
    
protected:
    bool _blocking;
    unsigned int _timeout;

protected:
    SOCKET_HANDLE_t     _socket;
};


#endif // __SOCKET_H__