#include "mbed.h"
#include "HTTPServer.h"
#include "FsHandler.h"
#include "RpcHandler.h"
#include "LocalFileSystem.h"
#include "mbed_rpc.h"

DigitalOut myled(LED1);

LocalFileSystem local("local");

HTTPServer  svr(p9, p10, p30, p29, "<Your AP Name>", "<Your Passphrase>", WPA);


RpcDigitalOut Led1(LED1, "Led1");
RpcDigitalOut Led2(LED2, "Led2");
RpcDigitalOut Led3(LED3, "Led3");
RpcDigitalOut Led4(LED4, "Led4");

int main() {
    std::string tim;
    
    /* Mount the local file system. */
    HTTPFsRequestHandler::mount("/local/", "/");    

    /* Add handler for file system access */    
    svr.addHandler<HTTPFsRequestHandler>("/");
    /* Add handler to acces RPC objects */
    svr.addHandler<HTTPRpcRequestHandler>("/rpc/");
    
    /* Start the server which will listen for incoming connections on port 80 */
    svr.start(80);
    
    
    while(1) {
        /* get the time and the uptime from WiFly */
        tim = svr.getTime();
        printf("Current time is : %s\n", tim.c_str());
        
       if (svr.poll(false) >= 0) {
            myled = !myled;
        }
        else {
            error("WiFly Polling failed.");
        }

    }
}
