/* HTTPConnection.cpp */

#include "mbed.h"
#include "HTTPConnection.h"

#define DEBUG

#include "debug.h"

#include <vector>
using std::vector;

using std::string;


const struct HTTPRequestConfig {
    const char* request_string;
    HTTPRequestType request_type;
} g_requestConfig[] = {
    { "GET",    HTTP_RT_GET },
    { "POST",   HTTP_RT_POST},
    { "PUT",    HTTP_RT_PUT},
    { "OPTIONS",HTTP_RT_OPTIONS},
    { "HEAD",   HTTP_RT_HEAD},
    { "DELETE", HTTP_RT_DELETE},
    { "TRACE",  HTTP_RT_TRACE},
    { "CONNECT",HTTP_RT_CONNECT}
};


HTTPConnection::HTTPConnection()
{
}


HTTPConnection::~HTTPConnection()
{
    close();
}

void HTTPConnection::close()
{
    m_Msg.headers.clear();
}

int HTTPConnection::parse(char* buffer)
{
    //  Check if buffer is invalid or its content not long enough.
    if ((buffer == NULL) || (strlen(buffer) < 4)) {
        ERR("Buffer content is invalid or too short.");
        return -1;
    }
    
    std::vector<std::string> args;
    args.clear();
    
    int argno = 0;
    //  decompose string into a list of arguments
    char s = 0; // current starting char
    int nLen = strlen(buffer)+1;
    for (int i = 0 ; i < nLen ; i++) {
        if ((buffer[i] == ' ') || (buffer[i] == '\n') || (buffer[i] == 0)) {
            // new arg found
            buffer[i] = 0;
            if (argno++ == 1) {
                //  its the uri
                // parse the uri args
                parseUriArgs(&buffer[s], m_Msg.args);
            }
            INFO("Found argument \"%s\"", &buffer[s]);
            args.push_back(&buffer[s]);
            s = i+1;
        }
    }
    
    // store the uri and the HTTP version
    m_Msg.uri = args[1];
    m_Msg.version = args[2];    
    
    //  Find matching request type
    for (int i = 0 ; i < sizeof(g_requestConfig)/sizeof(struct HTTPRequestConfig) ; i++) {
        if (args.at(0) == g_requestConfig[i].request_string) {
            m_Msg.request = g_requestConfig[i].request_type;
        }
    }
    args.clear();
    
    return 1;
}

int HTTPConnection::parseUriArgs(char *buffer, map<string,string>&args)
{
    // Check if the buffer is invalid or if the content is too short to be meaningful
    if ((strlen(buffer) <3) || (buffer == NULL))
        return -1;
        
    int args_start = -1;
    int value_start = -1;
    int buflen = strlen(buffer) +1;
    const char* argname = NULL;
    const char* valuename = NULL;
    for (int i = 0; i < buflen ; i++) {
        if (args_start == -1) {  // args section not yet found
            if (buffer[i] == '?') {  // starts with a question mark, so got it
                buffer[i] = 0;
                args_start = i; //  set the start of the args section
                INFO("Argument section found !");
            }
        }
        else {                  // search arg-value touples
            if (argname == NULL) {    //  arg-name found ?
                if (buffer[i] == '=') {
                    //  yes, separate the arg-name
                    buffer[i] = 0;
                    argname = &buffer[args_start];
                    value_start = i+1;
                    INFO("Argument name %s", argname);
                }
            }
            else { // search for end of value
                if ((buffer[i] == '&') || (buffer[i] == 0) || (buffer[i] == '\r') || (buffer[i] == '\n')) {
                    buffer[i] = 0;
                    valuename = &buffer[value_start];
                    INFO("Argument value %s", valuename);
                    args[argname] = valuename;
                    //  reset all indicators
                    argname = NULL;
                    valuename = NULL;
                }
            }
        }
    }
    
    return 0;
}
