#include "mbed.h"
#include "HttpServer.h"
#include "FsHandler.h"
#include "LocalFileSystem.h"

DigitalOut myled(LED1);

Serial pc(USBTX, USBRX, "pc");

static LocalFileSystem  local("local");


int main() {
    pc.baud(460800);

    HTTPFsRequestHandler::mount("/local/", "/");
       
    HttpServer  svr(p9, p10, p30, p29, "Spawnpoint", "Quantenoptik1", WPA);
    
    svr.addHandler<HTTPFsRequestHandler>("/");
    //  Start the server
    if (!svr.start(80) ) {
        error("SERVER FAILED TO START");
    }
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
