#include "mbed.h"
#include "BLE.h"
#include "BatteryService.h"
#include "DeviceInformationService.h"
#include "HIDService.h"
 
BLEDevice  ble;

Serial uart(USBTX, USBRX);
DigitalOut led01(LED1);
DigitalOut RFSWIO(LED2);
Ticker flipper;
DigitalIn btn01(P0_17);
DigitalIn btn02(P0_16);
DigitalIn btn03(P0_21);

bool flip_lock = false;

void flip() {
    if (!flip_lock) RFSWIO = !RFSWIO;
}

unsigned char keyData;
static const char     DEVICE_NAME[]        = "HID_Android_ShortCutKey";
static const uint16_t uuid16_list[]        = {GattService::UUID_HUMAN_INTERFACE_DEVICE_SERVICE};
static volatile bool  triggerSensorPolling = false;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}

char msg[25] = "NNN40 CONNECTED\n";
int main(void)
{   
    btn01.mode(PullUp);
    btn02.mode(PullUp);
    btn03.mode(PullUp);
    
    uart.baud(115200);
    uart.printf("Starting HID Service\r\n");
    RFSWIO = 1;
    led01 = 1;
    memset(msg, 0, 25);
    /*======BLE setup========*/
    ble.init();
    bool enableBonding = true;
    bool requireMITM   = true;
    ble.initializeSecurity(enableBonding, requireMITM, SecurityManager::IO_CAPS_NONE);  //IO_CAPS_DISPLAY_ONLY, IO_CAPS_NONE
    ble.onDisconnection(disconnectionCallback);
 
    /* Setup primary service. */
    HIDService hidService(ble);
    /* Setup auxiliary service. */
    DeviceInformationService deviceInfo(ble, "ARM", "CYNTEC", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
    /* Setup advertising. */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::KEYBOARD);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(1000);
    
    RFSWIO = 1;
    ble.startAdvertising();
    uart.printf("Starting advertising\r\n");
    wait(5);
    flipper.attach(&flip, 0.15);
        
    while (1) {
        if(ble.getGapState().connected){
            if(!btn01){
                hidService.updateReport(0x04, 0x2B);//0x04 ALT(LEFT) 0x2B   Keyboard TAB
                wait(0.03);
                hidService.updateReport(0x04, 0x00);//0x04 ALT(LEFT) 0x2B
                wait(0.5);
            }
            if(!btn02){
                hidService.updateReport(0x00, 0x28);//0x28   Keyboard RETURN(Enter)
                wait(0.03);
                hidService.updateReport(0x00, 0x00);
                wait(0.5);
            }
            if(!btn03){
                hidService.updateReport(0x08, 0x07);//0x08 Left GUI  0x07 Keyboard d
                wait(0.03);
                hidService.updateReport(0x00, 0x00);
                wait(0.5);
            }
        }
    }
}
