#include "TSL1401.h"

/* Macro */
#define TAOS_SI_HIGH    TAOS_SI = 1
#define TAOS_SI_LOW     TAOS_SI = 0
#define TAOS_CLK_HIGH   TAOS_CLK = 1
#define TAOS_CLK_LOW    TAOS_CLK = 0

/* Constructor */
TSL1401::TSL1401(PinName s, PinName c, PinName a )
{
    SI = s;
    CLK = c;
    A0 = new AnalogIn( a );
    GaussianMask7[0] = GaussianMask7[6] = 0.004;
    GaussianMask7[1] = GaussianMask7[5] = 0.054;
    GaussianMask7[2] = GaussianMask7[4] = 0.242;
    GaussianMask7[3] = 0.399;
}
/* Destructor */
TSL1401::~TSL1401()
{
    if( A0 != NULL)
    {
        delete  A0;
    }
}
/* Image Caputure */
void TSL1401::Capture()
{
    int i;
    DigitalOut TAOS_SI(SI);//setting output pin
    DigitalOut TAOS_CLK(CLK);
    
    TAOS_SI_HIGH;
    wait_us(3);
    TAOS_CLK_HIGH;
    wait_us(3);
    TAOS_SI_LOW;
    wait_us(3);
    TAOS_CLK_LOW;
    wait_us(3);
    for(i = 0; i < 128; i++) 
    {        
        TAOS_CLK_HIGH;     
        wait_us(1); 
        TAOS_CLK_LOW;
        wait_us(1);
    }
    wait_ms(10);//setting delay for in or out door
    TAOS_SI_HIGH;
    wait_us(3);
    TAOS_CLK_HIGH;
    wait_us(3);
    TAOS_SI_LOW;
    wait_us(3);
    TAOS_CLK_LOW;
    wait_us(3);
    
    for(i=0; i<128; i++)
    {                  
        ImageData[i] = A0->read()*100;  // input data from camera(one pixel each) 
        TAOS_CLK_HIGH;
        wait_us(2);
        TAOS_CLK_LOW;
        wait_us(2);     
    }
    return ;
}

void TSL1401::Median()
{
    int temp=0;
    for(int i=0; i<32; i++)
    {
           temp =  Sort(ImageData[4*i], ImageData[4*i+1], ImageData[4*i+2], ImageData[4*i+3]);
           MedianData[4*i]=temp;
           MedianData[4*i+1]=temp;
           MedianData[4*i+2]=temp;
           MedianData[4*i+3]=temp;
    }
    return ;
}

int TSL1401::Sort(int a, int b, int c, int d)
{
    int indexMin=0;
    int temp=0;
    int Array[4] = {a,b,c,d};
    
    for(int i=0; i<4; i++)
    {
       indexMin=i;
       for(int j=i+1; j<4; j++)
       {
        if(Array[j]<Array[indexMin]) indexMin=j;
       }
       temp = Array[indexMin];
       Array[indexMin]=Array[i];
       Array[i] = temp;
    }
    return (Array[1]+Array[2])/2;
}

void TSL1401::Gaussian()
{
    double result;
    for(int i=3; i<125; i++)
    {
        for(int j = 0; j < 7; j++) result += MedianData[i-3+j]*GaussianMask7[j];    
        GaussianData[i] = result; 
        result = 0;
    }
    GaussianData[0] = GaussianData[3]; 
    GaussianData[1] = GaussianData[3];
    GaussianData[2] = GaussianData[3];
    GaussianData[125] = GaussianData[124]; 
    GaussianData[126] = GaussianData[124];
    GaussianData[127] = GaussianData[124];
    
    return ;
}

    
