#include "mbed.h"
#include "STEPPER.h"

STEPPER::STEPPER(
PinName a, PinName a_, PinName b, PinName b_, int dir
):
 MotorPin(a, a_, b, b_)
{
    Direction = dir;
    step_cw[0] = 0x9;
    step_cw[1] = 0x8;
    step_cw[2] = 0xa;
    step_cw[3] = 0x2;
    step_cw[4] = 0x6;
    step_cw[5] = 0x4;
    step_cw[6] = 0x5;
    step_cw[7] = 0x1;
    step_ccw[0] = 0x1;
    step_ccw[1] = 0x5;
    step_ccw[2] = 0x4;
    step_ccw[3] = 0x6;
    step_ccw[4] = 0x2;
    step_ccw[5] = 0xa;
    step_ccw[6] = 0x8;
    step_ccw[7] = 0x9;
    Speed = 1000;
    count = 0;
}

STEPPER::~STEPPER()
{
    //?
}

void STEPPER::MotorStart()
{
   Motor.attach_us(this, &STEPPER::MotorControl,Speed);
}

void STEPPER::MotorOff()
{
    Motor.detach();
    MotorPin = 0x0;
}

void STEPPER::SetSpeed(int speed)
{
    Speed = speed;
}

void STEPPER::MotorControl()
{
    count++;
    if(count>7) count = 0;
    if(Direction) MotorPin = step_ccw[count];
    else MotorPin = step_cw[count];
}