#include "mbed.h"
#include "TextLCD.h"

AnalogIn LM35(p14);
DigitalOut WOpen(p5);
DigitalOut WClose(p6);
DigitalIn StepOpen(p8);
DigitalIn StepClose(p7);
DigitalOut AmberLED(p23);
DigitalOut GreenLED(p22);
DigitalOut RedLED(p21);

TextLCD lcd(p15, p16, p17, p18, p19, p20); //rs, e, d4-d7
BusOut stepper_out(p30,p29,p28,p27);

int step=0;
int x=0;
int dir=1;  //direction of motor


        int main()
        {
         float tempC,tempF,a[10],avg; //float integer for temp
         int i;
         
         while(1)
             {  
             avg=0;
            for(i=0;i<10;i++)
            {
            a[i]=LM35.read(); //read temp sensor
            AmberLED = 1
            wait(.02)
            AmberLED = 0
            wait(.02);
            }
            for(i=0;i<10;i++)
            {
            avg=avg+(a[i]/10);
            }

        tempC=(avg*3.685503686*100);
        tempF=(9.0*tempC)/5.0 + 32.0;
            lcd.locate(0,0);
            lcd.printf("  Temperature   "); //displays 'temperature' on the lcd screen
            lcd.locate(0,1);
            lcd.printf("%.2f C %.2f F",tempC,tempF); //displays the temperature reading on the LCD screen
        wait(.5);     
        
        if (tempC < 20.C) //If Temp is over 20 degrees, turn open window pin out on
        WClose = 1;
        Wopen = 0;
        GreenLed = 1;
        RedLed = 0;
        else                  //if Temp is not over 20 degree, turn close window pin out on
        WClose = 0;
        WOpen = 1;
        GreenLed = 0;
        RedLed = 1;
    
        While (1)
        {
            if (StepOpen ==1){
            for (x=0;x<=1024;x++);
            switch(Step)
            {
                case 0: stepper_out=0x1; break;        //8 step mootor requires 8 cases
                case 1: stepper_out=0x3; break;
                case 2: stepper_out=0x2; break;
                case 3: stepper_out=0x6; break;
                case 4: stepper_out=0x4; break;
                case 5: stepper_out=0x5; break;
                case 6: stepper_out=0x8; break;
                case 7: stepper_out=0x9; break;
                default : stepper_out=0x0; break;
                }
            
            if(dir) step++;else step--;
            
            if(step>7) step=0;
            if(step<0) step=7;
            wait(0.005) ;       //set speed of motor
            }
                
            
            
            
        
        
    }
 }